/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public enum Region {
    US_STANDARD(null),
    US_WEST("us-west-1"),
    US_WEST_2("us-west-2"),
    US_GOVCLOUD("us-gov-west-1"),
    EU_IRELAND("eu-west-1", "EU"),
    EU_FRANKFURT("eu-central-1"),
    AP_SINGAPORE("ap-southeast-1"),
    AP_SYDNEY("ap-southeast-2"),
    AP_TOKYO("ap-northeast-1"),
    SA_SAOPAULO("sa-east-1"),
    CN_BEIJING("cn-north-1");

    public static final Pattern S3_REGIONAL_ENDPOINT_PATTERN;
    private final List<String> regionIds;

    private Region(String ... regionIds) {
        this.regionIds = regionIds != null ? Arrays.asList(regionIds) : null;
    }

    public String toString() {
        return this.getFirstRegionId0();
    }

    public String getFirstRegionId() {
        return this.getFirstRegionId0();
    }

    private String getFirstRegionId0() {
        return this.regionIds == null || this.regionIds.isEmpty() ? null : this.regionIds.get(0);
    }

    public static Region fromValue(String s3RegionId) throws IllegalArgumentException {
        if (s3RegionId == null || s3RegionId.equals("US")) {
            return US_STANDARD;
        }
        for (Region region : Region.values()) {
            List<String> regionIds = region.regionIds;
            if (regionIds == null || !regionIds.contains(s3RegionId)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + s3RegionId + " value!");
    }

    static {
        S3_REGIONAL_ENDPOINT_PATTERN = Pattern.compile("s3[-.]([^.]+)\\.amazonaws\\.com(\\.[^.]*)?");
    }
}

