/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.model;

import com.amazonaws.1.11.21.shade.services.s3.model.CopyObjectRequest;
import com.amazonaws.1.11.21.shade.services.s3.model.CopyPartRequest;
import com.amazonaws.1.11.21.shade.services.s3.model.GetObjectRequest;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.Validate;

public final class ConditionalConstraints {
    private Date modifiedSince;
    private Date unmodifiedSince;

    private ConditionalConstraints(Date modifiedSince, Date unmodifiedSince) {
        Validate.isTrue((modifiedSince == null || unmodifiedSince == null ? 1 : 0) != 0, (String)"Specify either modifiedSince or umodifiedSince");
        this.modifiedSince = modifiedSince;
        this.unmodifiedSince = unmodifiedSince;
    }

    public static ConditionalConstraints from(Date modifiedSince, Date unmodifiedSince) {
        return new ConditionalConstraints(modifiedSince, unmodifiedSince);
    }

    public void populate(@NotNull GetObjectRequest request) {
        request.setModifiedSinceConstraint(this.modifiedSince);
        request.setUnmodifiedSinceConstraint(this.unmodifiedSince);
    }

    public void populate(@NotNull CopyObjectRequest request) {
        request.setModifiedSinceConstraint(this.modifiedSince);
        request.setUnmodifiedSinceConstraint(this.unmodifiedSince);
    }

    public void populate(@NotNull CopyPartRequest request) {
        request.setModifiedSinceConstraint(this.modifiedSince);
        request.setUnmodifiedSinceConstraint(this.unmodifiedSince);
    }
}

