/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.generated.transformers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class StringToDateTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss");
    private int priorityWeighting = 1;

    public StringToDateTransformer() {
        this.registerSourceType(DataTypeFactory.create(String.class));
        this.setReturnClass(Date.class);
        this.setName("StringToDateTransformer");
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            return SIMPLE_DATE_FORMAT.parse(src.toString());
        }
        catch (ParseException e) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)String.format("Could not parse %s using the format %s", src, SIMPLE_DATE_FORMAT.toPattern())), (Transformer)this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int value) {
        this.priorityWeighting = value;
    }
}

