/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.generated.processors;

import com.amazonaws.1.11.21.shade.services.s3.model.S3ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.3.9.0.api.transformer.TransformingValue;
import org.mule.devkit.3.9.0.internal.metadata.fixes.STUDIO7157;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.module.s3.S3Connector;
import org.mule.module.s3.exception.ExceptionDecorator;
import org.mule.module.s3.exception.S3ClientException;
import org.mule.security.oauth.callback.ProcessCallback;

public class GetObjectContentMessageProcessor
extends DevkitBasedMessageProcessor
implements MessageProcessor,
OperationMetaDataEnabled {
    protected Object bucketName;
    protected String _bucketNameType;
    protected Object key;
    protected String _keyType;
    protected Object versionId;
    protected String _versionIdType;
    protected Object modifiedSince;
    protected Date _modifiedSinceType;
    protected Object unmodifiedSince;
    protected Date _unmodifiedSinceType;
    protected Object mimeType;
    protected String _mimeTypeType;
    protected Object encoding;
    protected String _encodingType;

    public GetObjectContentMessageProcessor(String operationName) {
        super(operationName);
    }

    public void initialise() throws InitialisationException {
    }

    public void start() throws MuleException {
        super.start();
    }

    public void stop() throws MuleException {
        super.stop();
    }

    public void dispose() {
        super.dispose();
    }

    public void setBucketName(Object value) {
        this.bucketName = value;
    }

    public void setVersionId(Object value) {
        this.versionId = value;
    }

    public void setModifiedSince(Object value) {
        this.modifiedSince = value;
    }

    public void setMimeType(Object value) {
        this.mimeType = value;
    }

    public void setEncoding(Object value) {
        this.encoding = value;
    }

    public void setKey(Object value) {
        this.key = value;
    }

    public void setUnmodifiedSince(Object value) {
        this.unmodifiedSince = value;
    }

    public MuleEvent doProcess(MuleEvent event) throws Exception {
        Object moduleObject = null;
        moduleObject = this.findOrCreate(null, false, event);
        final String _transformedBucketName = (String)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_bucketNameType").getGenericType(), null, this.bucketName);
        final String _transformedKey = (String)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_keyType").getGenericType(), null, this.key);
        final String _transformedVersionId = (String)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_versionIdType").getGenericType(), null, this.versionId);
        final Date _transformedModifiedSince = (Date)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_modifiedSinceType").getGenericType(), null, this.modifiedSince);
        final Date _transformedUnmodifiedSince = (Date)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_unmodifiedSinceType").getGenericType(), null, this.unmodifiedSince);
        final String _transformedMimeType = (String)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_mimeTypeType").getGenericType(), null, this.mimeType);
        final String _transformedEncoding = (String)this.evaluateAndTransform(this.getMuleContext(), event, GetObjectContentMessageProcessor.class.getDeclaredField("_encodingType").getGenericType(), null, this.encoding);
        ProcessTemplate processTemplate = ((ProcessAdapter)moduleObject).getProcessTemplate();
        Object resultPayload = processTemplate.execute((ProcessCallback)new ProcessCallback<Object, Object>(){

            public List<Class<? extends Exception>> getManagedExceptions() {
                return Arrays.asList(S3ClientException.class);
            }

            public boolean isProtected() {
                return false;
            }

            public Object process(Object object) throws Exception {
                try {
                    return ((S3Connector)object).getObjectContent(_transformedBucketName, _transformedKey, _transformedVersionId, _transformedModifiedSince, _transformedUnmodifiedSince, _transformedMimeType, _transformedEncoding);
                }
                catch (Exception e) {
                    ExceptionDecorator handler = new ExceptionDecorator();
                    handler.handleException(e);
                    throw e;
                }
            }
        }, (MessageProcessor)this, event);
        ((DefaultMuleMessage)event.getMessage()).setPayload(((TransformingValue)resultPayload).getValue());
        ((DefaultMuleMessage)event.getMessage()).setMimeType(((TransformingValue)resultPayload).getDataType().getMimeType());
        ((DefaultMuleMessage)event.getMessage()).setEncoding(((TransformingValue)resultPayload).getDataType().getEncoding());
        return event;
    }

    public Result<MetaData> getInputMetaData() {
        return new DefaultResult(null, Result.Status.SUCCESS);
    }

    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        MetaDataModel metaDataPayload = this.getPojoOrSimpleModel(S3ObjectInputStream.class);
        DefaultMetaDataKey keyForStudio = new DefaultMetaDataKey("OUTPUT_METADATA", null);
        metaDataPayload.addProperty((MetaDataModelProperty)STUDIO7157.getStructureIdentifierMetaDataModelProperty((MetaDataKey)keyForStudio, false, false));
        return new DefaultResult((Object)new DefaultMetaData(metaDataPayload));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals((Object)dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        }
        return new DefaultSimpleMetaDataModel(dataType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        try {
            ConnectorMetaDataEnabled connector = (ConnectorMetaDataEnabled)this.findOrCreate(null, false, null);
            try {
                Result metadata = connector.getMetaData(metaDataKey);
                if (Result.Status.FAILURE.equals((Object)metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult(null, Result.Status.FAILURE, "There was an error processing metadata at S3Connector at getObjectContent retrieving was successful but result is null");
                }
                return metadata;
            }
            catch (Exception e) {
                return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
            }
        }
        catch (ClassCastException cast) {
            return new DefaultResult(null, Result.Status.FAILURE, "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        }
        catch (ConfigurationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (RegistrationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (InstantiationException e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
        catch (Exception e) {
            return new DefaultResult(null, Result.Status.FAILURE, e.getMessage(), FailureType.UNSPECIFIED, (Throwable)e);
        }
    }
}

