/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3.generated.connectivity;

import com.amazonaws.1.11.21.shade.Protocol;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.9.0.api.exception.ConfigurationWarning;
import org.mule.devkit.3.9.0.api.lifecycle.LifeCycleManager;
import org.mule.devkit.3.9.0.api.lifecycle.MuleContextAwareManager;
import org.mule.devkit.3.9.0.internal.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.9.0.internal.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.9.0.internal.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.9.0.internal.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.9.0.internal.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.9.0.internal.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.9.0.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.3.9.0.internal.metadata.MetaDataGeneratorUtils;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.module.s3.Config;
import org.mule.module.s3.generated.adapters.S3ConnectorConnectionManagementAdapter;
import org.mule.module.s3.generated.connectivity.ConfigS3ConnectorAdapter;
import org.mule.module.s3.generated.connectivity.ConnectionManagementConfigS3ConnectorConnectionKey;
import org.mule.module.s3.generated.pooling.DevkitGenericKeyedObjectPool;
import org.mule.module.s3.metadata.category.BucketNotificationCategory;

public class S3ConnectorConfigConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<S3ConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectorMetaDataEnabled,
ConnectionManagementConnectionManager<ConnectionManagementConfigS3ConnectorConnectionKey, S3ConnectorConnectionManagementAdapter, Config> {
    private String accessKey;
    private String secretKey;
    private boolean tryDefaultAWSCredentialsProviderChain;
    private Protocol protocol;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private Integer socketTimeout;
    private Integer connectionTimeout;
    private Integer maxConnections;
    private String storageUrl;
    private String roleARN;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Amazon S3";
    private static final String MODULE_VERSION = "4.2.0";
    private static final String DEVKIT_VERSION = "3.9.0";
    private static final String DEVKIT_BUILD = "UNNAMED.2793.f49b6c7";
    private static final String MIN_MULE_VERSION = "3.5.0";

    public void setSecretKey(String value) {
        this.secretKey = value;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setAccessKey(String value) {
        this.accessKey = value;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setTryDefaultAWSCredentialsProviderChain(boolean value) {
        this.tryDefaultAWSCredentialsProviderChain = value;
    }

    public boolean getTryDefaultAWSCredentialsProviderChain() {
        return this.tryDefaultAWSCredentialsProviderChain;
    }

    public void setProtocol(Protocol value) {
        this.protocol = value;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProxyHost(String value) {
        this.proxyHost = value;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyPort(Integer value) {
        this.proxyPort = value;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyUsername(String value) {
        this.proxyUsername = value;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyPassword(String value) {
        this.proxyPassword = value;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyDomain(String value) {
        this.proxyDomain = value;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyWorkstation(String value) {
        this.proxyWorkstation = value;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setSocketTimeout(Integer value) {
        this.socketTimeout = value;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setConnectionTimeout(Integer value) {
        this.connectionTimeout = value;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setMaxConnections(Integer value) {
        this.maxConnections = value;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setStorageUrl(String value) {
        this.storageUrl = value;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }

    public void setRoleARN(String value) {
        this.roleARN = value;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public S3ConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigS3ConnectorConnectionKey key) throws Exception {
        return (S3ConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigS3ConnectorConnectionKey key, S3ConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigS3ConnectorConnectionKey key, S3ConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, S3ConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigS3ConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigS3ConnectorConnectionKey(this.getAccessKey(), this.getSecretKey(), this.getTryDefaultAWSCredentialsProviderChain());
    }

    @Override
    public ConnectionManagementConfigS3ConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedAccessKey = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("accessKey").getGenericType(), null, this.getAccessKey());
            if (_transformedAccessKey == null) {
                throw new UnableToAcquireConnectionException("Parameter accessKey in method connect can't be null because is not @Optional");
            }
            String _transformedSecretKey = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("secretKey").getGenericType(), null, this.getSecretKey());
            if (_transformedSecretKey == null) {
                throw new UnableToAcquireConnectionException("Parameter secretKey in method connect can't be null because is not @Optional");
            }
            Boolean _transformedTryDefaultAWSCredentialsProviderChain = (Boolean)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("tryDefaultAWSCredentialsProviderChain").getGenericType(), null, this.getTryDefaultAWSCredentialsProviderChain());
            return new ConnectionManagementConfigS3ConnectorConnectionKey(_transformedAccessKey, _transformedSecretKey, _transformedTryDefaultAWSCredentialsProviderChain);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigS3ConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        ConfigS3ConnectorAdapter connection = new ConfigS3ConnectorAdapter();
        connection.setProtocol(this.getProtocol());
        connection.setProxyHost(this.getProxyHost());
        connection.setProxyPort(this.getProxyPort());
        connection.setProxyUsername(this.getProxyUsername());
        connection.setProxyPassword(this.getProxyPassword());
        connection.setProxyDomain(this.getProxyDomain());
        connection.setProxyWorkstation(this.getProxyWorkstation());
        connection.setSocketTimeout(this.getSocketTimeout());
        connection.setConnectionTimeout(this.getConnectionTimeout());
        connection.setMaxConnections(this.getMaxConnections());
        connection.setStorageUrl(this.getStorageUrl());
        connection.setRoleARN(this.getRoleARN());
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<Config, ConnectionManagementConfigS3ConnectorConnectionKey> connection) {
        S3ConnectorConnectionManagementAdapter connector = new S3ConnectorConnectionManagementAdapter();
        connector.setConfig(connection.getStrategy());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        S3ConnectorConnectionManagementAdapter connector = (S3ConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConfig());
        return strategy;
    }

    public TestResult test() {
        try {
            ConfigS3ConnectorAdapter strategy = (ConfigS3ConnectorAdapter)this.newConnection();
            MuleContextAwareManager.setMuleContext(strategy, this.muleContext);
            LifeCycleManager.executeInitialiseAndStart(strategy);
            ConnectionManagementConnectorAdapter connectorAdapter = this.newConnector(strategy);
            MuleContextAwareManager.setMuleContext(connectorAdapter, this.muleContext);
            LifeCycleManager.executeInitialiseAndStart(connectorAdapter);
            strategy.test(this.getDefaultConnectionKey());
            return new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (ConfigurationWarning warning) {
            return (DefaultTestResult)ConnectivityTestingErrorHandler.buildWarningTestResult((Exception)((Object)warning));
        }
        catch (Exception e) {
            return (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        S3ConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigS3ConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
                BucketNotificationCategory bucketNotificationCategory = new BucketNotificationCategory();
                bucketNotificationCategory.setConnector(connection);
                gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(bucketNotificationCategory.metaDataKeys(), "BucketNotificationCategory"));
                DefaultResult defaultResult = new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult defaultResult;
                block19: {
                    defaultResult = new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return defaultResult;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DefaultResult defaultResult2 = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        S3ConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigS3ConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                MetaData metaData = null;
                TypeDescribingProperty property = (TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class);
                String category = ((DefaultMetaDataKey)metaDataKey).getCategory();
                if (category != null) {
                    if (!category.equals("BucketNotificationCategory")) {
                        throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[BucketNotificationCategory]" + ", but found [" + category + "] instead");
                    }
                } else {
                    throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[BucketNotificationCategory]");
                }
                BucketNotificationCategory bucketNotificationCategory = new BucketNotificationCategory();
                bucketNotificationCategory.setConnector(connection);
                metaData = bucketNotificationCategory.getMetaData(metaDataKey);
                metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
                DefaultResult defaultResult = new DefaultResult((Object)metaData);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult defaultResult;
                block22: {
                    defaultResult = new DefaultResult(null, Result.Status.FAILURE, MetaDataGeneratorUtils.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
                    if (connection == null) break block22;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return defaultResult;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    DefaultResult defaultResult2 = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception exception) {}
            }
        }
    }
}

