/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.s3;

import com.amazonaws.1.11.21.shade.ClientConfiguration;
import com.amazonaws.1.11.21.shade.Protocol;
import com.amazonaws.1.11.21.shade.auth.BasicAWSCredentials;
import com.amazonaws.1.11.21.shade.auth.BasicSessionCredentials;
import com.amazonaws.1.11.21.shade.retry.PredefinedRetryPolicies;
import com.amazonaws.1.11.21.shade.retry.RetryPolicy;
import com.amazonaws.1.11.21.shade.services.s3.AmazonS3;
import com.amazonaws.1.11.21.shade.services.s3.AmazonS3Client;
import com.amazonaws.1.11.21.shade.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleResult;
import org.apache.commons.lang.StringUtils;
import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final String AWS_S3_SIGNER_TYPE = "AWSS3V4SignerType";
    private static final int AWS_CLIENT_MAX_ERROR_RETRY = 10;
    private static final long CONNECTION_TTL = 60000L;
    private Protocol protocol;
    private String proxyHost;
    private Integer proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyDomain;
    private String proxyWorkstation;
    private Integer socketTimeout;
    private Integer connectionTimeout;
    private Integer maxConnections;
    private String storageUrl;
    private String roleARN;
    private AmazonS3 client;

    public void connect(String accessKey, String secretKey, boolean tryDefaultAWSCredentialsProviderChain) throws ConnectionException {
        if (!tryDefaultAWSCredentialsProviderChain && (StringUtils.isBlank((String)accessKey) || StringUtils.isBlank((String)secretKey))) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "001", "Access Key or Secret Key is blank");
        }
        try {
            if (this.getClient() == null) {
                this.setClient(this.createAmazonS3(accessKey, secretKey, tryDefaultAWSCredentialsProviderChain));
            }
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "002", e.getMessage(), (Throwable)e);
        }
    }

    public void testConnect(String accessKey, String secretKey, boolean tryDefaultAWSCredentialsProviderChain) throws ConnectionException {
        this.connect(accessKey, secretKey, tryDefaultAWSCredentialsProviderChain);
        try {
            this.getClient().getS3AccountOwner();
        }
        catch (Exception e) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "003", e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.getClient() != null) {
            this.setClient(null);
        }
    }

    public boolean isConnected() {
        return this.getClient() != null;
    }

    public String connectionId() {
        return "amazon_s3-";
    }

    private AmazonS3 createAmazonS3(String accessKey, String secretKey, boolean tryDefaultAWSCredentialsProviderChain) {
        ClientConfiguration clientConfig = new ClientConfiguration();
        if (StringUtils.isNotBlank((String)this.getProxyUsername())) {
            clientConfig.setProxyUsername(this.getProxyUsername());
        }
        if (this.getProxyPort() != null) {
            clientConfig.setProxyPort(this.getProxyPort());
        }
        if (StringUtils.isNotBlank((String)this.getProxyPassword())) {
            clientConfig.setProxyPassword(this.getProxyPassword());
        }
        if (StringUtils.isNotBlank((String)this.getProxyHost())) {
            clientConfig.setProxyHost(this.getProxyHost());
        }
        if (StringUtils.isNotBlank((String)this.getProxyDomain())) {
            clientConfig.setProxyDomain(this.getProxyDomain());
        }
        if (StringUtils.isNotBlank((String)this.getProxyWorkstation())) {
            clientConfig.setProxyWorkstation(this.getProxyWorkstation());
        }
        if (this.getProtocol() != null) {
            clientConfig.setProtocol(this.getProtocol());
        }
        if (this.getConnectionTimeout() != null) {
            clientConfig.setConnectionTimeout(this.getConnectionTimeout());
        }
        if (this.getSocketTimeout() != null) {
            clientConfig.setSocketTimeout(this.getSocketTimeout());
        }
        if (this.getMaxConnections() != null) {
            clientConfig.setMaxConnections(this.getMaxConnections());
        }
        if (this.getStorageUrl() != null) {
            clientConfig.setSignerOverride(AWS_S3_SIGNER_TYPE);
        }
        RetryPolicy retryPolicy = new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, PredefinedRetryPolicies.DEFAULT_BACKOFF_STRATEGY, 10, true);
        clientConfig.setRetryPolicy(retryPolicy);
        clientConfig.setConnectionTTL(60000L);
        AmazonS3Client amazonS3Client = null;
        if (StringUtils.isNotBlank((String)this.getRoleARN())) {
            try {
                AWSSecurityTokenServiceClient stsClient = tryDefaultAWSCredentialsProviderChain ? new AWSSecurityTokenServiceClient() : new AWSSecurityTokenServiceClient(new BasicAWSCredentials(accessKey, secretKey));
                AssumeRoleRequest assumeRequest = new AssumeRoleRequest().withRoleArn(this.getRoleARN()).withDurationSeconds(3600).withRoleSessionName("WithRoleARN");
                AssumeRoleResult assumeResult = stsClient.assumeRole(assumeRequest);
                BasicSessionCredentials temporaryCredentials = new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
                amazonS3Client = new AmazonS3Client(temporaryCredentials, clientConfig);
            }
            catch (Exception e) {
                logger.warn("Can not connect using Role ARN or AWS Default Credentials Provider Chain. Error Message: " + e.getMessage());
            }
        } else if (tryDefaultAWSCredentialsProviderChain) {
            try {
                amazonS3Client = new AmazonS3Client(clientConfig);
            }
            catch (Exception e) {
                logger.warn("Can not connect using AWS Default Credentials Provider Chain. Error Message: " + e.getMessage());
            }
        } else {
            amazonS3Client = new AmazonS3Client(new BasicAWSCredentials(accessKey, secretKey), clientConfig);
        }
        if (amazonS3Client != null && this.getStorageUrl() != null) {
            amazonS3Client.setEndpoint(this.getStorageUrl());
        }
        return amazonS3Client;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public AmazonS3 getClient() {
        return this.client;
    }

    public void setClient(AmazonS3 client) {
        this.client = client;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public String getProxyDomain() {
        return this.proxyDomain;
    }

    public void setProxyDomain(String proxyDomain) {
        this.proxyDomain = proxyDomain;
    }

    public String getProxyWorkstation() {
        return this.proxyWorkstation;
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.proxyWorkstation = proxyWorkstation;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }

    public String getStorageUrl() {
        return this.storageUrl;
    }

    public void setStorageUrl(String storageUrl) {
        this.storageUrl = storageUrl;
    }

    public String getRoleARN() {
        return this.roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }
}

