/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.protocol;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.http.4.5.2.shade.HttpConnection;
import org.apache.http.4.5.2.shade.HttpException;
import org.apache.http.4.5.2.shade.HttpHost;
import org.apache.http.4.5.2.shade.HttpInetConnection;
import org.apache.http.4.5.2.shade.HttpRequest;
import org.apache.http.4.5.2.shade.HttpRequestInterceptor;
import org.apache.http.4.5.2.shade.HttpVersion;
import org.apache.http.4.5.2.shade.ProtocolException;
import org.apache.http.4.5.2.shade.ProtocolVersion;
import org.apache.http.4.5.2.shade.annotation.Immutable;
import org.apache.http.4.5.2.shade.protocol.HttpContext;
import org.apache.http.4.5.2.shade.protocol.HttpCoreContext;
import org.apache.http.4.5.2.shade.util.Args;

@Immutable
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext corecontext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targethost = corecontext.getTargetHost();
            if (targethost == null) {
                HttpConnection conn = corecontext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targethost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targethost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targethost.toHostString());
        }
    }
}

