/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.protocol;

import java.io.IOException;
import org.apache.http.4.5.2.shade.HttpEntityEnclosingRequest;
import org.apache.http.4.5.2.shade.HttpException;
import org.apache.http.4.5.2.shade.HttpRequest;
import org.apache.http.4.5.2.shade.HttpRequestInterceptor;
import org.apache.http.4.5.2.shade.annotation.ThreadSafe;
import org.apache.http.4.5.2.shade.protocol.HttpContext;
import org.apache.http.4.5.2.shade.protocol.HttpDateGenerator;
import org.apache.http.4.5.2.shade.util.Args;

@ThreadSafe
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

