/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.impl.io;

import java.io.IOException;
import org.apache.http.4.5.2.shade.Header;
import org.apache.http.4.5.2.shade.HeaderIterator;
import org.apache.http.4.5.2.shade.HttpException;
import org.apache.http.4.5.2.shade.HttpMessage;
import org.apache.http.4.5.2.shade.annotation.NotThreadSafe;
import org.apache.http.4.5.2.shade.io.HttpMessageWriter;
import org.apache.http.4.5.2.shade.io.SessionOutputBuffer;
import org.apache.http.4.5.2.shade.message.BasicLineFormatter;
import org.apache.http.4.5.2.shade.message.LineFormatter;
import org.apache.http.4.5.2.shade.params.HttpParams;
import org.apache.http.4.5.2.shade.util.Args;
import org.apache.http.4.5.2.shade.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    protected final SessionOutputBuffer sessionBuffer;
    protected final CharArrayBuffer lineBuf;
    protected final LineFormatter lineFormatter;

    @Deprecated
    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
        Args.notNull(buffer, "Session input buffer");
        this.sessionBuffer = buffer;
        this.lineBuf = new CharArrayBuffer(128);
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
    }

    public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
        this.sessionBuffer = Args.notNull(buffer, "Session input buffer");
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    protected abstract void writeHeadLine(T var1) throws IOException;

    @Override
    public void write(T message) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        this.writeHeadLine(message);
        HeaderIterator it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
        }
        this.lineBuf.clear();
        this.sessionBuffer.writeLine(this.lineBuf);
    }
}

