/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.impl.client;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.4.5.2.shade.HttpException;
import org.apache.http.4.5.2.shade.HttpHost;
import org.apache.http.4.5.2.shade.HttpRequest;
import org.apache.http.4.5.2.shade.annotation.ThreadSafe;
import org.apache.http.4.5.2.shade.client.ClientProtocolException;
import org.apache.http.4.5.2.shade.client.config.RequestConfig;
import org.apache.http.4.5.2.shade.client.methods.CloseableHttpResponse;
import org.apache.http.4.5.2.shade.client.methods.Configurable;
import org.apache.http.4.5.2.shade.client.methods.HttpExecutionAware;
import org.apache.http.4.5.2.shade.client.methods.HttpRequestWrapper;
import org.apache.http.4.5.2.shade.client.protocol.HttpClientContext;
import org.apache.http.4.5.2.shade.conn.ClientConnectionManager;
import org.apache.http.4.5.2.shade.conn.ClientConnectionRequest;
import org.apache.http.4.5.2.shade.conn.HttpClientConnectionManager;
import org.apache.http.4.5.2.shade.conn.ManagedClientConnection;
import org.apache.http.4.5.2.shade.conn.routing.HttpRoute;
import org.apache.http.4.5.2.shade.conn.scheme.SchemeRegistry;
import org.apache.http.4.5.2.shade.impl.DefaultConnectionReuseStrategy;
import org.apache.http.4.5.2.shade.impl.client.CloseableHttpClient;
import org.apache.http.4.5.2.shade.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.4.5.2.shade.impl.execchain.MinimalClientExec;
import org.apache.http.4.5.2.shade.params.BasicHttpParams;
import org.apache.http.4.5.2.shade.params.HttpParams;
import org.apache.http.4.5.2.shade.protocol.BasicHttpContext;
import org.apache.http.4.5.2.shade.protocol.HttpContext;
import org.apache.http.4.5.2.shade.protocol.HttpRequestExecutor;
import org.apache.http.4.5.2.shade.util.Args;

@ThreadSafe
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit tunit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, tunit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

