/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.impl.client;

import java.security.Principal;
import javax.net.ssl.SSLSession;
import org.apache.http.4.5.2.shade.HttpConnection;
import org.apache.http.4.5.2.shade.annotation.Immutable;
import org.apache.http.4.5.2.shade.auth.AuthScheme;
import org.apache.http.4.5.2.shade.auth.AuthState;
import org.apache.http.4.5.2.shade.auth.Credentials;
import org.apache.http.4.5.2.shade.client.UserTokenHandler;
import org.apache.http.4.5.2.shade.client.protocol.HttpClientContext;
import org.apache.http.4.5.2.shade.conn.ManagedHttpClientConnection;
import org.apache.http.4.5.2.shade.protocol.HttpContext;

@Immutable
public class DefaultUserTokenHandler
implements UserTokenHandler {
    public static final DefaultUserTokenHandler INSTANCE = new DefaultUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedHttpClientConnection && (sslsession = ((ManagedHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

