/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.impl.client;

import java.io.IOException;
import org.apache.http.4.5.2.shade.HttpEntity;
import org.apache.http.4.5.2.shade.HttpResponse;
import org.apache.http.4.5.2.shade.StatusLine;
import org.apache.http.4.5.2.shade.annotation.Immutable;
import org.apache.http.4.5.2.shade.client.HttpResponseException;
import org.apache.http.4.5.2.shade.client.ResponseHandler;
import org.apache.http.4.5.2.shade.util.EntityUtils;

@Immutable
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

