/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.4.5.2.shade.impl.auth;

import org.apache.http.4.5.2.shade.annotation.Immutable;
import org.apache.http.4.5.2.shade.auth.AuthScheme;
import org.apache.http.4.5.2.shade.auth.AuthSchemeFactory;
import org.apache.http.4.5.2.shade.auth.AuthSchemeProvider;
import org.apache.http.4.5.2.shade.impl.auth.KerberosScheme;
import org.apache.http.4.5.2.shade.params.HttpParams;
import org.apache.http.4.5.2.shade.protocol.HttpContext;

@Immutable
public class KerberosSchemeFactory
implements AuthSchemeFactory,
AuthSchemeProvider {
    private final boolean stripPort;
    private final boolean useCanonicalHostname;

    public KerberosSchemeFactory(boolean stripPort, boolean useCanonicalHostname) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = useCanonicalHostname;
    }

    public KerberosSchemeFactory(boolean stripPort) {
        this.stripPort = stripPort;
        this.useCanonicalHostname = true;
    }

    public KerberosSchemeFactory() {
        this(true, true);
    }

    public boolean isStripPort() {
        return this.stripPort;
    }

    public boolean isUseCanonicalHostname() {
        return this.useCanonicalHostname;
    }

    @Override
    public AuthScheme newInstance(HttpParams params) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }

    @Override
    public AuthScheme create(HttpContext context) {
        return new KerberosScheme(this.stripPort, this.useCanonicalHostname);
    }
}

