/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.ser.std;

import com.fasterxml.2.6.6.shade.jackson.core.JsonGenerator;
import com.fasterxml.2.6.6.shade.jackson.databind.JavaType;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonMappingException;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonNode;
import com.fasterxml.2.6.6.shade.jackson.databind.SerializerProvider;
import com.fasterxml.2.6.6.shade.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.2.6.6.shade.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.2.6.6.shade.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    @Deprecated
    public boolean isEmpty(Object value) {
        return this.isEmpty((SerializerProvider)null, value);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        if (value == null) {
            return true;
        }
        String str = value.toString();
        return str.isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, gen);
        this.serialize(value, gen, provider);
        typeSer.writeTypeSuffixForScalar(value, gen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectStringFormat(typeHint);
        }
    }
}

