/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.ser.std;

import com.fasterxml.2.6.6.shade.jackson.core.JsonGenerator;
import com.fasterxml.2.6.6.shade.jackson.databind.SerializerProvider;
import com.fasterxml.2.6.6.shade.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }
}

