/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.ser.impl;

import com.fasterxml.2.6.6.shade.jackson.annotation.JsonFormat;
import com.fasterxml.2.6.6.shade.jackson.core.JsonGenerator;
import com.fasterxml.2.6.6.shade.jackson.databind.AnnotationIntrospector;
import com.fasterxml.2.6.6.shade.jackson.databind.BeanProperty;
import com.fasterxml.2.6.6.shade.jackson.databind.JavaType;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonMappingException;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonNode;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.SerializationFeature;
import com.fasterxml.2.6.6.shade.jackson.databind.SerializerProvider;
import com.fasterxml.2.6.6.shade.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.2.6.6.shade.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.2.6.6.shade.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.2.6.6.shade.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.2.6.6.shade.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.2.6.6.shade.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.2.6.6.shade.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.2.6.6.shade.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, JsonSerializer<?> ser, Boolean unwrapSingle) {
        super(src, prop, unwrapSingle);
        this._elementSerializer = ser;
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return new StringArraySerializer(this, prop, this._elementSerializer, unwrapSingle);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        JsonSerializer<Object> ser = null;
        Boolean unwrapSingle = null;
        if (property != null) {
            JsonFormat.Value format;
            Object serDef;
            AnnotationIntrospector ai = provider.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null && (serDef = ai.findContentSerializer(m)) != null) {
                ser = provider.serializerInstance(m, serDef);
            }
            if ((format = property.findFormatOverrides(ai)) != null) {
                unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
            }
        }
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if (this.isDefaultSerializer(ser = (ser = this.findConvertingContentSerializer(provider, property, ser)) == null ? provider.findValueSerializer(String.class, property) : provider.handleSecondaryContextualization(ser, property))) {
            ser = null;
        }
        if (ser == this._elementSerializer && unwrapSingle == this._unwrapSingle) {
            return this;
        }
        return new StringArraySerializer(this, property, ser, unwrapSingle);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, String[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value) {
        return value.length == 1;
    }

    @Override
    public final void serialize(String[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.length;
        if (len == 1 && (this._unwrapSingle == null && provider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE)) {
            this.serializeContents(value, gen, provider);
            return;
        }
        gen.writeStartArray(len);
        this.serializeContents(value, gen, provider);
        gen.writeEndArray();
    }

    @Override
    public void serializeContents(String[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value, gen, provider, this._elementSerializer);
            return;
        }
        for (int i = 0; i < len; ++i) {
            String str = value[i];
            if (str == null) {
                gen.writeNull();
                continue;
            }
            gen.writeString(value[i]);
        }
    }

    private void serializeContentsSlow(String[] value, JsonGenerator gen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException {
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            String str = value[i];
            if (str == null) {
                provider.defaultSerializeNull(gen);
                continue;
            }
            ser.serialize(value[i], gen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("string"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2;
        if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
            v2.itemsFormat(JsonFormatTypes.STRING);
        }
    }
}

