/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.ext;

import com.fasterxml.2.6.6.shade.jackson.databind.DeserializationContext;
import com.fasterxml.2.6.6.shade.jackson.databind.deser.std.FromStringDeserializer;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class DOMDeserializer<T>
extends FromStringDeserializer<T> {
    private static final long serialVersionUID = 1L;
    private static final DocumentBuilderFactory _parserFactory = DocumentBuilderFactory.newInstance();

    protected DOMDeserializer(Class<T> cls) {
        super(cls);
    }

    @Override
    public abstract T _deserialize(String var1, DeserializationContext var2);

    protected final Document parse(String value) throws IllegalArgumentException {
        try {
            return _parserFactory.newDocumentBuilder().parse(new InputSource(new StringReader(value)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON String as XML: " + e.getMessage(), e);
        }
    }

    static {
        _parserFactory.setNamespaceAware(true);
    }

    public static class DocumentDeserializer
    extends DOMDeserializer<Document> {
        private static final long serialVersionUID = 1L;

        public DocumentDeserializer() {
            super(Document.class);
        }

        @Override
        public Document _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return this.parse(value);
        }
    }

    public static class NodeDeserializer
    extends DOMDeserializer<Node> {
        private static final long serialVersionUID = 1L;

        public NodeDeserializer() {
            super(Node.class);
        }

        @Override
        public Node _deserialize(String value, DeserializationContext ctxt) throws IllegalArgumentException {
            return this.parse(value);
        }
    }
}

