/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.deser.std;

import com.fasterxml.2.6.6.shade.jackson.core.JsonParser;
import com.fasterxml.2.6.6.shade.jackson.core.JsonToken;
import com.fasterxml.2.6.6.shade.jackson.databind.BeanProperty;
import com.fasterxml.2.6.6.shade.jackson.databind.DeserializationConfig;
import com.fasterxml.2.6.6.shade.jackson.databind.DeserializationContext;
import com.fasterxml.2.6.6.shade.jackson.databind.DeserializationFeature;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.JsonMappingException;
import com.fasterxml.2.6.6.shade.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.2.6.6.shade.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.2.6.6.shade.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.util.ClassUtil;
import com.fasterxml.2.6.6.shade.jackson.databind.util.CompactStringObjectMap;
import com.fasterxml.2.6.6.shade.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.lang.reflect.Method;

@JacksonStdImpl
public class EnumDeserializer
extends StdScalarDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    protected final CompactStringObjectMap _enumLookup;
    protected Object[] _enumsByIndex;

    public EnumDeserializer(EnumResolver res) {
        super(res.getEnumClass());
        this._enumLookup = res.constructLookup();
        this._enumsByIndex = res.getRawEnums();
    }

    public static JsonDeserializer<?> deserializerForCreator(DeserializationConfig config, Class<?> enumClass, AnnotatedMethod factory) {
        Class<?> paramClass = factory.getRawParameterType(0);
        if (config.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess(factory.getMember());
        }
        return new FactoryBasedDeserializer(enumClass, factory, paramClass);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken curr = p.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING || curr == JsonToken.FIELD_NAME) {
            String name = p.getText();
            Object result = this._enumLookup.find(name);
            if (result == null) {
                return this._deserializeAltString(p, ctxt, name);
            }
            return result;
        }
        if (curr == JsonToken.VALUE_NUMBER_INT) {
            this._checkFailOnNumber(ctxt);
            int index = p.getIntValue();
            if (index >= 0 && index <= this._enumsByIndex.length) {
                return this._enumsByIndex[index];
            }
            if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                throw ctxt.weirdNumberException(index, this._enumClass(), "index value outside legal index range [0.." + (this._enumsByIndex.length - 1) + "]");
            }
            return null;
        }
        return this._deserializeOther(p, ctxt);
    }

    private final Object _deserializeAltString(JsonParser p, DeserializationContext ctxt, String name) throws IOException {
        if ((name = name.trim()).length() == 0) {
            if (ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return null;
            }
        } else {
            char c = name.charAt(0);
            if (c >= '0' && c <= '9') {
                try {
                    int ix = Integer.parseInt(name);
                    this._checkFailOnNumber(ctxt);
                    if (ix >= 0 && ix <= this._enumsByIndex.length) {
                        return this._enumsByIndex[ix];
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
            throw ctxt.weirdStringException(name, this._enumClass(), "value not one of declared Enum instance names: " + this._enumLookup.keys());
        }
        return null;
    }

    protected Object _deserializeOther(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken curr = p.getCurrentToken();
        if (ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS) && p.isExpectedStartArrayToken()) {
            p.nextToken();
            Object parsed = this.deserialize(p, ctxt);
            curr = p.nextToken();
            if (curr != JsonToken.END_ARRAY) {
                throw ctxt.wrongTokenException(p, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single '" + this._enumClass().getName() + "' value but there was more than a single value in the array");
            }
            return parsed;
        }
        throw ctxt.mappingException(this._enumClass());
    }

    protected void _checkFailOnNumber(DeserializationContext ctxt) throws IOException {
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) {
            throw ctxt.mappingException("Not allowed to deserialize Enum value out of JSON number (disable DeserializationConfig.DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS to allow)");
        }
    }

    protected Class<?> _enumClass() {
        return this.handledType();
    }

    protected static class FactoryBasedDeserializer
    extends StdDeserializer<Object>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 1L;
        protected final Class<?> _inputType;
        protected final Method _factory;
        protected final JsonDeserializer<?> _deser;

        public FactoryBasedDeserializer(Class<?> cls, AnnotatedMethod f, Class<?> inputType) {
            super(cls);
            this._factory = f.getAnnotated();
            this._inputType = inputType;
            this._deser = null;
        }

        protected FactoryBasedDeserializer(FactoryBasedDeserializer base, JsonDeserializer<?> deser) {
            super(base._valueClass);
            this._inputType = base._inputType;
            this._factory = base._factory;
            this._deser = deser;
        }

        @Override
        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            if (this._deser == null && this._inputType != String.class) {
                return new FactoryBasedDeserializer(this, ctxt.findContextualValueDeserializer(ctxt.constructType(this._inputType), property));
            }
            return this;
        }

        @Override
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonToken curr;
            Object value = this._deser != null ? this._deser.deserialize(p, ctxt) : ((curr = p.getCurrentToken()) == JsonToken.VALUE_STRING || curr == JsonToken.FIELD_NAME ? p.getText() : p.getValueAsString());
            try {
                return this._factory.invoke((Object)this._valueClass, value);
            }
            catch (Exception e) {
                Throwable t = ClassUtil.getRootCause(e);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw ctxt.instantiationException(this._valueClass, t);
            }
        }

        @Override
        public Object deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
            if (this._deser == null) {
                return this.deserialize(p, ctxt);
            }
            return typeDeserializer.deserializeTypedFromAny(p, ctxt);
        }
    }
}

