/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.2.6.6.shade.jackson.databind.deser.std;

import com.fasterxml.2.6.6.shade.jackson.core.JsonParser;
import com.fasterxml.2.6.6.shade.jackson.databind.DeserializationContext;
import com.fasterxml.2.6.6.shade.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.2.6.6.shade.jackson.databind.util.ByteBufferBackedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferDeserializer
extends StdScalarDeserializer<ByteBuffer> {
    private static final long serialVersionUID = 1L;

    protected ByteBufferDeserializer() {
        super(ByteBuffer.class);
    }

    @Override
    public ByteBuffer deserialize(JsonParser parser, DeserializationContext cx) throws IOException {
        byte[] b = parser.getBinaryValue();
        return ByteBuffer.wrap(b);
    }

    @Override
    public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt, ByteBuffer intoValue) throws IOException {
        ByteBufferBackedOutputStream out = new ByteBufferBackedOutputStream(intoValue);
        jp.readBinaryValue(ctxt.getBase64Variant(), out);
        out.close();
        return intoValue;
    }
}

