/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.util;

import com.amazonaws.1.11.21.shade.ClientConfiguration;
import com.amazonaws.1.11.21.shade.util.HttpClientWrappingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.4.5.2.shade.HttpHost;
import org.apache.http.4.5.2.shade.auth.AuthScope;
import org.apache.http.4.5.2.shade.auth.NTCredentials;
import org.apache.http.4.5.2.shade.client.methods.CloseableHttpResponse;
import org.apache.http.4.5.2.shade.client.methods.HttpGet;
import org.apache.http.4.5.2.shade.impl.client.DefaultHttpClient;
import org.apache.http.4.5.2.shade.params.BasicHttpParams;
import org.apache.http.4.5.2.shade.params.HttpConnectionParams;
import org.apache.http.4.5.2.shade.params.HttpProtocolParams;

public class RuntimeHttpUtils {
    public static InputStream fetchFile(URI uri, ClientConfiguration config) throws IOException {
        CloseableHttpResponse response;
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpProtocolParams.setUserAgent(httpClientParams, RuntimeHttpUtils.getUserAgent(config));
        HttpConnectionParams.setConnectionTimeout(httpClientParams, RuntimeHttpUtils.getConnectionTimeout(config));
        HttpConnectionParams.setSoTimeout(httpClientParams, RuntimeHttpUtils.getSocketTimeout(config));
        DefaultHttpClient httpclient = new DefaultHttpClient(httpClientParams);
        if (config != null) {
            String proxyHost = config.getProxyHost();
            int proxyPort = config.getProxyPort();
            if (proxyHost != null && proxyPort > 0) {
                HttpHost proxy = new HttpHost(proxyHost, proxyPort);
                httpclient.getParams().setParameter("http.route.default-proxy", proxy);
                if (config.getProxyUsername() != null && config.getProxyPassword() != null) {
                    httpclient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new NTCredentials(config.getProxyUsername(), config.getProxyPassword(), config.getProxyWorkstation(), config.getProxyDomain()));
                }
            }
        }
        if ((response = httpclient.execute(new HttpGet(uri))).getStatusLine().getStatusCode() != 200) {
            throw new IOException("Error fetching file from " + uri + ": " + response);
        }
        return new HttpClientWrappingInputStream(httpclient, response.getEntity().getContent());
    }

    private static String getUserAgent(ClientConfiguration config) {
        String userAgent = null;
        if (config != null) {
            userAgent = config.getUserAgent();
        }
        if (userAgent == null) {
            userAgent = ClientConfiguration.DEFAULT_USER_AGENT;
        } else if (!ClientConfiguration.DEFAULT_USER_AGENT.equals(userAgent)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        return userAgent;
    }

    private static int getConnectionTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getConnectionTimeout();
        }
        return 10000;
    }

    private static int getSocketTimeout(ClientConfiguration config) {
        if (config != null) {
            return config.getSocketTimeout();
        }
        return 50000;
    }

    public static URI toUri(String endpoint, ClientConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("ClientConfiguration cannot be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint cannot be null");
        }
        if (!endpoint.contains("://")) {
            endpoint = config.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

