/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.securitytoken;

import com.amazonaws.1.11.21.shade.ClientConfiguration;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.auth.AWSCredentials;
import com.amazonaws.1.11.21.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.11.21.shade.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.1.11.21.shade.client.AwsAsyncClientParams;
import com.amazonaws.1.11.21.shade.handlers.AsyncHandler;
import com.amazonaws.1.11.21.shade.services.securitytoken.AWSSecurityTokenServiceAsync;
import com.amazonaws.1.11.21.shade.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleWithSAMLResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.DecodeAuthorizationMessageRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.DecodeAuthorizationMessageResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetCallerIdentityRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetCallerIdentityResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetFederationTokenResult;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetSessionTokenResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSSecurityTokenServiceAsyncClient
extends AWSSecurityTokenServiceClient
implements AWSSecurityTokenServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AWSSecurityTokenServiceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSSecurityTokenServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AWSSecurityTokenServiceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(AssumeRoleRequest request) {
        return this.assumeRoleAsync(request, null);
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(final AssumeRoleRequest request, final AsyncHandler<AssumeRoleRequest, AssumeRoleResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                AssumeRoleResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.assumeRole(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(AssumeRoleWithSAMLRequest request) {
        return this.assumeRoleWithSAMLAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithSAMLResult> assumeRoleWithSAMLAsync(final AssumeRoleWithSAMLRequest request, final AsyncHandler<AssumeRoleWithSAMLRequest, AssumeRoleWithSAMLResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssumeRoleWithSAMLResult>(){

            @Override
            public AssumeRoleWithSAMLResult call() throws Exception {
                AssumeRoleWithSAMLResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithSAML(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(AssumeRoleWithWebIdentityRequest request) {
        return this.assumeRoleWithWebIdentityAsync(request, null);
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(final AssumeRoleWithWebIdentityRequest request, final AsyncHandler<AssumeRoleWithWebIdentityRequest, AssumeRoleWithWebIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                AssumeRoleWithWebIdentityResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithWebIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(DecodeAuthorizationMessageRequest request) {
        return this.decodeAuthorizationMessageAsync(request, null);
    }

    @Override
    public Future<DecodeAuthorizationMessageResult> decodeAuthorizationMessageAsync(final DecodeAuthorizationMessageRequest request, final AsyncHandler<DecodeAuthorizationMessageRequest, DecodeAuthorizationMessageResult> asyncHandler) {
        return this.executorService.submit(new Callable<DecodeAuthorizationMessageResult>(){

            @Override
            public DecodeAuthorizationMessageResult call() throws Exception {
                DecodeAuthorizationMessageResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.decodeAuthorizationMessage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(GetCallerIdentityRequest request) {
        return this.getCallerIdentityAsync(request, null);
    }

    @Override
    public Future<GetCallerIdentityResult> getCallerIdentityAsync(final GetCallerIdentityRequest request, final AsyncHandler<GetCallerIdentityRequest, GetCallerIdentityResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetCallerIdentityResult>(){

            @Override
            public GetCallerIdentityResult call() throws Exception {
                GetCallerIdentityResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.getCallerIdentity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(GetFederationTokenRequest request) {
        return this.getFederationTokenAsync(request, null);
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(final GetFederationTokenRequest request, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.getFederationToken(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(GetSessionTokenRequest request) {
        return this.getSessionTokenAsync(request, null);
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(final GetSessionTokenRequest request, final AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                GetSessionTokenResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.getSessionToken(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync() {
        return this.getSessionTokenAsync(new GetSessionTokenRequest());
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) {
        return this.getSessionTokenAsync(new GetSessionTokenRequest(), asyncHandler);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

