/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.s3.transfer.internal;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.event.ProgressEventType;
import com.amazonaws.1.11.21.shade.event.ProgressListenerChain;
import com.amazonaws.1.11.21.shade.event.SDKProgressPublisher;
import com.amazonaws.1.11.21.shade.services.s3.AmazonS3;
import com.amazonaws.1.11.21.shade.services.s3.model.CopyObjectRequest;
import com.amazonaws.1.11.21.shade.services.s3.model.PartETag;
import com.amazonaws.1.11.21.shade.services.s3.transfer.Transfer;
import com.amazonaws.1.11.21.shade.services.s3.transfer.TransferManager;
import com.amazonaws.1.11.21.shade.services.s3.transfer.internal.CompleteMultipartCopy;
import com.amazonaws.1.11.21.shade.services.s3.transfer.internal.CopyCallable;
import com.amazonaws.1.11.21.shade.services.s3.transfer.internal.CopyImpl;
import com.amazonaws.1.11.21.shade.services.s3.transfer.internal.TransferMonitor;
import com.amazonaws.1.11.21.shade.services.s3.transfer.model.CopyResult;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class CopyMonitor
implements Callable<CopyResult>,
TransferMonitor {
    private final AmazonS3 s3;
    private final ExecutorService threadPool;
    private final CopyObjectRequest origReq;
    private final CopyCallable multipartCopyCallable;
    private final CopyImpl transfer;
    private final ProgressListenerChain listener;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private boolean isCopyDone = false;
    private Future<CopyResult> future;

    public synchronized Future<CopyResult> getFuture() {
        return this.future;
    }

    private synchronized void setFuture(Future<CopyResult> future) {
        this.future = future;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCopyDone;
    }

    private synchronized void markAllDone() {
        this.isCopyDone = true;
    }

    public static CopyMonitor create(TransferManager manager, CopyImpl transfer, ExecutorService threadPool, CopyCallable multipartCopyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        CopyMonitor copyMonitor = new CopyMonitor(manager, transfer, threadPool, multipartCopyCallable, copyObjectRequest, progressListenerChain);
        copyMonitor.setFuture(threadPool.submit(copyMonitor));
        return copyMonitor;
    }

    private CopyMonitor(TransferManager manager, CopyImpl transfer, ExecutorService threadPool, CopyCallable multipartCopyCallable, CopyObjectRequest copyObjectRequest, ProgressListenerChain progressListenerChain) {
        this.s3 = manager.getAmazonS3Client();
        this.multipartCopyCallable = multipartCopyCallable;
        this.origReq = copyObjectRequest;
        this.listener = progressListenerChain;
        this.transfer = transfer;
        this.threadPool = threadPool;
    }

    @Override
    public CopyResult call() throws Exception {
        try {
            CopyResult result = this.multipartCopyCallable.call();
            if (result == null) {
                this.futures.addAll(this.multipartCopyCallable.getFutures());
                this.setFuture(this.threadPool.submit(new CompleteMultipartCopy(this.multipartCopyCallable.getMultipartUploadId(), this.s3, this.origReq, this.futures, this.listener, this)));
            } else {
                this.copyComplete();
            }
            return result;
        }
        catch (CancellationException e) {
            this.transfer.setState(Transfer.TransferState.Canceled);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_CANCELED_EVENT);
            throw new AmazonClientException("Upload canceled");
        }
        catch (Exception e) {
            this.transfer.setState(Transfer.TransferState.Failed);
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
    }

    void copyComplete() {
        this.markAllDone();
        this.transfer.setState(Transfer.TransferState.Completed);
        if (this.multipartCopyCallable.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
    }
}

