/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.ListKeysRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListKeysRequestMarshaller
implements Marshaller<Request<ListKeysRequest>, ListKeysRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListKeysRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListKeysRequest> marshall(ListKeysRequest listKeysRequest) {
        if (listKeysRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListKeysRequest> request = new DefaultRequest<ListKeysRequest>(listKeysRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListKeys");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listKeysRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listKeysRequest.getLimit());
            }
            if (listKeysRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listKeysRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

