/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.ListKeyPoliciesRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListKeyPoliciesRequestMarshaller
implements Marshaller<Request<ListKeyPoliciesRequest>, ListKeyPoliciesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListKeyPoliciesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListKeyPoliciesRequest> marshall(ListKeyPoliciesRequest listKeyPoliciesRequest) {
        if (listKeyPoliciesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListKeyPoliciesRequest> request = new DefaultRequest<ListKeyPoliciesRequest>(listKeyPoliciesRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListKeyPolicies");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listKeyPoliciesRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(listKeyPoliciesRequest.getKeyId());
            }
            if (listKeyPoliciesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listKeyPoliciesRequest.getLimit());
            }
            if (listKeyPoliciesRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listKeyPoliciesRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

