/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.ListGrantsRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListGrantsRequestMarshaller
implements Marshaller<Request<ListGrantsRequest>, ListGrantsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListGrantsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListGrantsRequest> marshall(ListGrantsRequest listGrantsRequest) {
        if (listGrantsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGrantsRequest> request = new DefaultRequest<ListGrantsRequest>(listGrantsRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.ListGrants");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listGrantsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listGrantsRequest.getLimit());
            }
            if (listGrantsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listGrantsRequest.getMarker());
            }
            if (listGrantsRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(listGrantsRequest.getKeyId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

