/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.GetKeyPolicyRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetKeyPolicyRequestMarshaller
implements Marshaller<Request<GetKeyPolicyRequest>, GetKeyPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetKeyPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetKeyPolicyRequest> marshall(GetKeyPolicyRequest getKeyPolicyRequest) {
        if (getKeyPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetKeyPolicyRequest> request = new DefaultRequest<GetKeyPolicyRequest>(getKeyPolicyRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.GetKeyPolicy");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getKeyPolicyRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(getKeyPolicyRequest.getKeyId());
            }
            if (getKeyPolicyRequest.getPolicyName() != null) {
                jsonGenerator.writeFieldName("PolicyName").writeValue(getKeyPolicyRequest.getPolicyName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

