/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.DisableKeyRotationRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DisableKeyRotationRequestMarshaller
implements Marshaller<Request<DisableKeyRotationRequest>, DisableKeyRotationRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DisableKeyRotationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DisableKeyRotationRequest> marshall(DisableKeyRotationRequest disableKeyRotationRequest) {
        if (disableKeyRotationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisableKeyRotationRequest> request = new DefaultRequest<DisableKeyRotationRequest>(disableKeyRotationRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.DisableKeyRotation");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disableKeyRotationRequest.getKeyId() != null) {
                jsonGenerator.writeFieldName("KeyId").writeValue(disableKeyRotationRequest.getKeyId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

