/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.services.kms.model.transform;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.DefaultRequest;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.internal.SdkInternalList;
import com.amazonaws.1.11.21.shade.internal.SdkInternalMap;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.services.kms.model.DecryptRequest;
import com.amazonaws.1.11.21.shade.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class DecryptRequestMarshaller
implements Marshaller<Request<DecryptRequest>, DecryptRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DecryptRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DecryptRequest> marshall(DecryptRequest decryptRequest) {
        if (decryptRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DecryptRequest> request = new DefaultRequest<DecryptRequest>(decryptRequest, "AWSKMS");
        request.addHeader("X-Amz-Target", "TrentService.Decrypt");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList grantTokensList;
            SdkInternalMap encryptionContextMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (decryptRequest.getCiphertextBlob() != null) {
                jsonGenerator.writeFieldName("CiphertextBlob").writeValue(decryptRequest.getCiphertextBlob());
            }
            if (!(encryptionContextMap = (SdkInternalMap)decryptRequest.getEncryptionContext()).isEmpty() || !encryptionContextMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("EncryptionContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry encryptionContextMapValue : encryptionContextMap.entrySet()) {
                    if (encryptionContextMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)encryptionContextMapValue.getKey());
                    jsonGenerator.writeValue((String)encryptionContextMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(grantTokensList = (SdkInternalList)decryptRequest.getGrantTokens()).isEmpty() || !grantTokensList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("GrantTokens");
                jsonGenerator.writeStartArray();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonGenerator.writeValue(grantTokensListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

