/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.protocol.json;

import com.amazonaws.1.11.21.shade.http.JsonErrorResponseHandler;
import com.amazonaws.1.11.21.shade.http.JsonResponseHandler;
import com.amazonaws.1.11.21.shade.internal.http.JsonErrorCodeParser;
import com.amazonaws.1.11.21.shade.internal.http.JsonErrorMessageParser;
import com.amazonaws.1.11.21.shade.protocol.json.JsonOperationMetadata;
import com.amazonaws.1.11.21.shade.protocol.json.SdkStructuredJsonFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.transform.JsonErrorUnmarshaller;
import com.amazonaws.1.11.21.shade.transform.JsonUnmarshallerContext;
import com.amazonaws.1.11.21.shade.transform.Unmarshaller;
import com.fasterxml.2.6.6.shade.jackson.core.JsonFactory;
import java.util.List;
import java.util.Map;

public abstract class SdkStructuredJsonFactoryImpl
implements SdkStructuredJsonFactory {
    private final JsonFactory jsonFactory;
    private final Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers;

    public SdkStructuredJsonFactoryImpl(JsonFactory jsonFactory, Map<Class<?>, Unmarshaller<?, JsonUnmarshallerContext>> unmarshallers) {
        this.jsonFactory = jsonFactory;
        this.unmarshallers = unmarshallers;
    }

    @Override
    public StructuredJsonGenerator createWriter(String contentType) {
        return this.createWriter(this.jsonFactory, contentType);
    }

    protected abstract StructuredJsonGenerator createWriter(JsonFactory var1, String var2);

    @Override
    public <T> JsonResponseHandler<T> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return new JsonResponseHandler<T>(responseUnmarshaller, this.unmarshallers, this.jsonFactory, operationMetadata.isHasStreamingSuccessResponse(), operationMetadata.isPayloadJson());
    }

    @Override
    public JsonErrorResponseHandler createErrorResponseHandler(List<JsonErrorUnmarshaller> errorUnmarshallers, String customErrorCodeFieldName) {
        return new JsonErrorResponseHandler(errorUnmarshallers, this.getErrorCodeParser(customErrorCodeFieldName), JsonErrorMessageParser.DEFAULT_ERROR_MESSAGE_PARSER, this.jsonFactory);
    }

    private JsonErrorCodeParser getErrorCodeParser(String customErrorCodeFieldName) {
        return new JsonErrorCodeParser(customErrorCodeFieldName);
    }
}

