/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.protocol.json;

import com.amazonaws.1.11.21.shade.AmazonServiceException;
import com.amazonaws.1.11.21.shade.AmazonWebServiceResponse;
import com.amazonaws.1.11.21.shade.SDKGlobalConfiguration;
import com.amazonaws.1.11.21.shade.annotation.SdkProtectedApi;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.http.HttpResponseHandler;
import com.amazonaws.1.11.21.shade.protocol.json.JsonClientMetadata;
import com.amazonaws.1.11.21.shade.protocol.json.JsonContentTypeResolver;
import com.amazonaws.1.11.21.shade.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.1.11.21.shade.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.1.11.21.shade.protocol.json.JsonOperationMetadata;
import com.amazonaws.1.11.21.shade.protocol.json.SdkStructuredCborFactory;
import com.amazonaws.1.11.21.shade.protocol.json.SdkStructuredJsonFactory;
import com.amazonaws.1.11.21.shade.protocol.json.SdkStructuredPlainJsonFactory;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.amazonaws.1.11.21.shade.transform.JsonErrorUnmarshaller;
import com.amazonaws.1.11.21.shade.transform.JsonUnmarshallerContext;
import com.amazonaws.1.11.21.shade.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    public StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponsMetadata.getCustomErrorCodeFieldName());
    }

    public String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        return this.isCborEnabled() ? SdkStructuredCborFactory.SDK_CBOR_FACTORY : SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        return this.isCborEnabled() ? JsonContentTypeResolver.CBOR : JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && !SDKGlobalConfiguration.isCborDisabled();
    }
}

