/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.protocol.json;

import com.amazonaws.1.11.21.shade.annotation.SdkInternalApi;
import com.amazonaws.1.11.21.shade.protocol.json.SdkJsonGenerator;
import com.amazonaws.1.11.21.shade.protocol.json.StructuredJsonGenerator;
import com.fasterxml.2.6.6.shade.jackson.core.JsonFactory;
import com.fasterxml.2.6.6.shade.jackson.dataformat.cbor.CBORGenerator;
import java.io.IOException;
import java.util.Date;

@SdkInternalApi
class SdkCborGenerator
extends SdkJsonGenerator {
    private static final int CBOR_TAG_TIMESTAP = 1;

    public SdkCborGenerator(JsonFactory factory, String contentType) {
        super(factory, contentType);
    }

    @Override
    public StructuredJsonGenerator writeValue(Date date) {
        if (!(this.getGenerator() instanceof CBORGenerator)) {
            throw new IllegalStateException("SdkCborGenerator is not created with a CBORGenerator.");
        }
        CBORGenerator generator = (CBORGenerator)this.getGenerator();
        try {
            generator.writeTag(1);
            generator.writeNumber(date.getTime());
        }
        catch (IOException e) {
            throw new SdkJsonGenerator.JsonGenerationException(e);
        }
        return this;
    }
}

