/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.partitions;

import com.amazonaws.1.11.21.shade.annotation.SdkInternalApi;
import com.amazonaws.1.11.21.shade.partitions.PartitionRegionImpl;
import com.amazonaws.1.11.21.shade.partitions.model.Partition;
import com.amazonaws.1.11.21.shade.partitions.model.Region;
import com.amazonaws.1.11.21.shade.regions.AbstractRegionMetadataProvider;
import com.amazonaws.1.11.21.shade.util.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@SdkInternalApi
public class PartitionMetadataProvider
extends AbstractRegionMetadataProvider {
    private final Map<String, Partition> partitionMap = new HashMap<String, Partition>();
    private final Map<String, com.amazonaws.1.11.21.shade.regions.Region> regionCache = new ConcurrentHashMap<String, com.amazonaws.1.11.21.shade.regions.Region>();

    public PartitionMetadataProvider(List<Partition> partitions) {
        ValidationUtils.assertNotNull(partitions, "partitions");
        for (Partition p : partitions) {
            this.partitionMap.put(p.getPartition(), p);
        }
    }

    @Override
    public List<com.amazonaws.1.11.21.shade.regions.Region> getRegions() {
        ArrayList<com.amazonaws.1.11.21.shade.regions.Region> regions = new ArrayList<com.amazonaws.1.11.21.shade.regions.Region>();
        for (Partition p : this.partitionMap.values()) {
            for (Map.Entry<String, Region> entry : p.getRegions().entrySet()) {
                regions.add(new com.amazonaws.1.11.21.shade.regions.Region(new PartitionRegionImpl(entry.getKey(), p)));
            }
        }
        return Collections.unmodifiableList(regions);
    }

    @Override
    public com.amazonaws.1.11.21.shade.regions.Region getRegion(String regionName) {
        if (regionName == null) {
            return null;
        }
        com.amazonaws.1.11.21.shade.regions.Region regionFromCache = this.getRegionFromCache(regionName);
        if (regionFromCache != null) {
            return regionFromCache;
        }
        return this.createNewRegion(regionName);
    }

    private com.amazonaws.1.11.21.shade.regions.Region createNewRegion(String regionName) {
        for (Partition p : this.partitionMap.values()) {
            if (!p.hasRegion(regionName)) continue;
            return this.cacheRegion(new PartitionRegionImpl(regionName, p));
        }
        return null;
    }

    private com.amazonaws.1.11.21.shade.regions.Region getRegionFromCache(String regionName) {
        return this.regionCache.get(regionName);
    }

    private com.amazonaws.1.11.21.shade.regions.Region cacheRegion(PartitionRegionImpl regionImpl) {
        com.amazonaws.1.11.21.shade.regions.Region region = new com.amazonaws.1.11.21.shade.regions.Region(regionImpl);
        this.regionCache.put(region.getName(), region);
        return region;
    }

    @Override
    public List<com.amazonaws.1.11.21.shade.regions.Region> getRegionsForService(String serviceName) {
        List<com.amazonaws.1.11.21.shade.regions.Region> allRegions = this.getRegions();
        ArrayList<com.amazonaws.1.11.21.shade.regions.Region> serviceSupportedRegions = new ArrayList<com.amazonaws.1.11.21.shade.regions.Region>();
        for (com.amazonaws.1.11.21.shade.regions.Region r : allRegions) {
            if (!r.isServiceSupported(serviceName)) continue;
            serviceSupportedRegions.add(r);
        }
        return serviceSupportedRegions;
    }
}

