/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.http.timers.request;

import com.amazonaws.1.11.21.shade.annotation.SdkInternalApi;
import com.amazonaws.1.11.21.shade.annotation.SdkTestInternalApi;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.http.timers.TimeoutThreadPoolBuilder;
import com.amazonaws.1.11.21.shade.http.timers.request.HttpRequestAbortTaskImpl;
import com.amazonaws.1.11.21.shade.http.timers.request.HttpRequestAbortTaskTracker;
import com.amazonaws.1.11.21.shade.http.timers.request.HttpRequestAbortTaskTrackerImpl;
import com.amazonaws.1.11.21.shade.http.timers.request.NoOpHttpRequestAbortTaskTracker;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.4.5.2.shade.client.methods.HttpRequestBase;

@ThreadSafe
@SdkInternalApi
public class HttpRequestTimer {
    private volatile ScheduledThreadPoolExecutor executor;

    public HttpRequestAbortTaskTracker startTimer(HttpRequestBase apacheRequest, int requestTimeoutMillis) {
        if (this.isTimeoutDisabled(requestTimeoutMillis)) {
            return NoOpHttpRequestAbortTaskTracker.INSTANCE;
        }
        if (this.executor == null) {
            this.initializeExecutor();
        }
        HttpRequestAbortTaskImpl timerTask = new HttpRequestAbortTaskImpl(apacheRequest);
        ScheduledFuture<?> timerTaskFuture = this.executor.schedule(timerTask, (long)requestTimeoutMillis, TimeUnit.MILLISECONDS);
        return new HttpRequestAbortTaskTrackerImpl(timerTask, timerTaskFuture);
    }

    private boolean isTimeoutDisabled(int requestTimeoutMillis) {
        return requestTimeoutMillis <= 0;
    }

    private synchronized void initializeExecutor() {
        if (this.executor == null) {
            this.executor = TimeoutThreadPoolBuilder.buildDefaultTimeoutThreadPool();
        }
    }

    public synchronized void shutdown() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @SdkTestInternalApi
    public ScheduledThreadPoolExecutor getExecutor() {
        return this.executor;
    }
}

