/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.http.apache.request.impl;

import com.amazonaws.1.11.21.shade.AmazonClientException;
import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.http.HttpMethodName;
import com.amazonaws.1.11.21.shade.http.RepeatableInputStreamRequestEntity;
import com.amazonaws.1.11.21.shade.http.apache.utils.ApacheUtils;
import com.amazonaws.1.11.21.shade.http.request.HttpRequestFactory;
import com.amazonaws.1.11.21.shade.http.settings.HttpClientSettings;
import com.amazonaws.1.11.21.shade.util.FakeIOException;
import com.amazonaws.1.11.21.shade.util.SdkHttpUtils;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.4.5.2.shade.HttpEntity;
import org.apache.http.4.5.2.shade.client.config.RequestConfig;
import org.apache.http.4.5.2.shade.client.methods.HttpDelete;
import org.apache.http.4.5.2.shade.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.4.5.2.shade.client.methods.HttpGet;
import org.apache.http.4.5.2.shade.client.methods.HttpHead;
import org.apache.http.4.5.2.shade.client.methods.HttpPatch;
import org.apache.http.4.5.2.shade.client.methods.HttpPost;
import org.apache.http.4.5.2.shade.client.methods.HttpPut;
import org.apache.http.4.5.2.shade.client.methods.HttpRequestBase;

public class ApacheHttpRequestFactory
implements HttpRequestFactory<HttpRequestBase> {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final List<String> ignoreHeaders = Arrays.asList("Content-Length", "Host");

    @Override
    public HttpRequestBase create(Request<?> request, HttpClientSettings settings) throws FakeIOException {
        boolean putParamsInUri;
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri(endpoint.toString(), request.getResourcePath(), true);
        String encodedParams = SdkHttpUtils.encodeParameters(request);
        boolean requestHasNoPayload = request.getContent() != null;
        boolean requestIsPost = request.getHttpMethod() == HttpMethodName.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (encodedParams != null && putParamsInUri) {
            uri = uri + "?" + encodedParams;
        }
        HttpRequestBase base = this.createApacheRequest(request, uri, encodedParams);
        this.addHeadersToRequest(base, request);
        this.addRequestConfig(base, request, settings);
        return base;
    }

    private void addRequestConfig(HttpRequestBase base, Request<?> request, HttpClientSettings settings) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectionRequestTimeout(settings.getConnectionPoolRequestTimeout()).setConnectTimeout(settings.getConnectionTimeout()).setSocketTimeout(settings.getSocketTimeout()).setStaleConnectionCheckEnabled(true).setLocalAddress(settings.getLocalAddress());
        if (HttpMethodName.PUT == request.getHttpMethod() && settings.isUseExpectContinue()) {
            requestConfigBuilder.setExpectContinueEnabled(true);
        }
        base.setConfig(requestConfigBuilder.build());
    }

    private HttpRequestBase createApacheRequest(Request<?> request, String uri, String encodedParams) throws FakeIOException {
        switch (request.getHttpMethod()) {
            case HEAD: {
                return new HttpHead(uri);
            }
            case GET: {
                return new HttpGet(uri);
            }
            case DELETE: {
                return new HttpDelete(uri);
            }
            case PATCH: {
                return this.wrapEntity(request, new HttpPatch(uri), encodedParams);
            }
            case POST: {
                return this.wrapEntity(request, new HttpPost(uri), encodedParams);
            }
            case PUT: {
                return this.wrapEntity(request, new HttpPut(uri), encodedParams);
            }
        }
        throw new AmazonClientException("Unknown HTTP method name: " + (Object)((Object)request.getHttpMethod()));
    }

    private HttpRequestBase wrapEntity(Request<?> request, HttpEntityEnclosingRequestBase entityEnclosingRequest, String encodedParams) throws FakeIOException {
        if (HttpMethodName.POST == request.getHttpMethod()) {
            if (request.getContent() == null && encodedParams != null) {
                entityEnclosingRequest.setEntity(ApacheUtils.newStringEntity(encodedParams));
            } else {
                entityEnclosingRequest.setEntity(new RepeatableInputStreamRequestEntity(request));
            }
        } else if (request.getContent() != null) {
            HttpEntity entity = new RepeatableInputStreamRequestEntity(request);
            if (request.getHeaders().get("Content-Length") == null) {
                entity = ApacheUtils.newBufferedHttpEntity(entity);
            }
            entityEnclosingRequest.setEntity(entity);
        }
        return entityEnclosingRequest;
    }

    private void addHeadersToRequest(HttpRequestBase httpRequest, Request<?> request) {
        httpRequest.addHeader("Host", this.getHostHeaderValue(request.getEndpoint()));
        for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
            if (ignoreHeaders.contains(entry.getKey())) continue;
            httpRequest.addHeader(entry.getKey(), entry.getValue());
        }
        if (httpRequest.getHeaders("Content-Type") == null || httpRequest.getHeaders("Content-Type").length == 0) {
            httpRequest.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_ENCODING.toLowerCase());
        }
    }

    private String getHostHeaderValue(URI endpoint) {
        return SdkHttpUtils.isUsingNonDefaultPort(endpoint) ? endpoint.getHost() + ":" + endpoint.getPort() : endpoint.getHost();
    }
}

