/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.http.apache.client.impl;

import com.amazonaws.1.11.21.shade.util.CRC32ChecksumCalculatingInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.4.5.2.shade.Header;
import org.apache.http.4.5.2.shade.HttpEntity;
import org.apache.http.4.5.2.shade.HttpException;
import org.apache.http.4.5.2.shade.HttpResponse;
import org.apache.http.4.5.2.shade.HttpResponseInterceptor;
import org.apache.http.4.5.2.shade.entity.HttpEntityWrapper;
import org.apache.http.4.5.2.shade.protocol.HttpContext;

public class CRC32ChecksumResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HttpEntity entity = response.getEntity();
        Header[] headers = response.getHeaders("x-amz-crc32");
        if (entity == null || headers == null || headers.length == 0) {
            return;
        }
        HttpEntityWrapper crc32ResponseEntity = new HttpEntityWrapper(entity){
            private final InputStream content;
            {
                this.content = new CRC32ChecksumCalculatingInputStream(this.wrappedEntity.getContent());
            }

            @Override
            public InputStream getContent() throws IOException {
                return this.content;
            }
        };
        response.setEntity(crc32ResponseEntity);
        context.setAttribute(CRC32ChecksumCalculatingInputStream.class.getName(), crc32ResponseEntity.getContent());
    }
}

