/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.http.apache.client.impl;

import com.amazonaws.1.11.21.shade.http.AmazonHttpClient;
import com.amazonaws.1.11.21.shade.http.IdleConnectionReaper;
import com.amazonaws.1.11.21.shade.http.apache.SdkProxyRoutePlanner;
import com.amazonaws.1.11.21.shade.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.amazonaws.1.11.21.shade.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import com.amazonaws.1.11.21.shade.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import com.amazonaws.1.11.21.shade.http.apache.client.impl.SdkHttpClient;
import com.amazonaws.1.11.21.shade.http.apache.utils.ApacheUtils;
import com.amazonaws.1.11.21.shade.http.client.ConnectionManagerFactory;
import com.amazonaws.1.11.21.shade.http.client.HttpClientFactory;
import com.amazonaws.1.11.21.shade.http.conn.ClientConnectionManagerFactory;
import com.amazonaws.1.11.21.shade.http.conn.SdkConnectionKeepAliveStrategy;
import com.amazonaws.1.11.21.shade.http.protocol.SdkHttpRequestExecutor;
import com.amazonaws.1.11.21.shade.http.settings.HttpClientSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.4.5.2.shade.conn.ConnectionKeepAliveStrategy;
import org.apache.http.4.5.2.shade.conn.HttpClientConnectionManager;
import org.apache.http.4.5.2.shade.impl.client.HttpClientBuilder;
import org.apache.http.4.5.2.shade.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm);
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (this.isProxyEnabled(settings)) {
            LOG.info((Object)("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort()));
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getNonProxyHosts()));
            if (this.isAuthenticatedProxy(settings)) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }

    private boolean isAuthenticatedProxy(HttpClientSettings settings) {
        return settings.getProxyUsername() != null && settings.getProxyPassword() != null;
    }

    private boolean isProxyEnabled(HttpClientSettings settings) {
        return settings.getProxyHost() != null && settings.getProxyPort() > 0;
    }
}

