/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.handlers;

import com.amazonaws.1.11.21.shade.Request;
import com.amazonaws.1.11.21.shade.Response;
import com.amazonaws.1.11.21.shade.handlers.RequestHandler;
import com.amazonaws.1.11.21.shade.handlers.RequestHandler2;
import com.amazonaws.1.11.21.shade.util.AWSRequestMetrics;
import com.amazonaws.1.11.21.shade.util.TimingInfo;

final class RequestHandler2Adaptor
extends RequestHandler2 {
    private final RequestHandler old;

    RequestHandler2Adaptor(RequestHandler old) {
        if (old == null) {
            throw new IllegalArgumentException();
        }
        this.old = old;
    }

    @Override
    public void beforeRequest(Request<?> request) {
        this.old.beforeRequest(request);
    }

    @Override
    public void afterResponse(Request<?> request, Response<?> response) {
        AWSRequestMetrics awsRequestMetrics = request == null ? null : request.getAWSRequestMetrics();
        Object awsResponse = response == null ? null : response.getAwsResponse();
        TimingInfo timingInfo = awsRequestMetrics == null ? null : awsRequestMetrics.getTimingInfo();
        this.old.afterResponse(request, awsResponse, timingInfo);
    }

    @Override
    public void afterError(Request<?> request, Response<?> response, Exception e) {
        this.old.afterError(request, e);
    }

    public int hashCode() {
        return this.old.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof RequestHandler2Adaptor)) {
            return false;
        }
        RequestHandler2Adaptor that = (RequestHandler2Adaptor)o;
        return this.old.equals(that.old);
    }
}

