/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.auth;

import com.amazonaws.1.11.21.shade.annotation.SdkInternalApi;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.auth.SessionCredentialsHolder;
import com.amazonaws.1.11.21.shade.internal.SdkPredicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
@ThreadSafe
class ShouldDoAsyncSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final long ASYNC_REFRESH_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    ShouldDoAsyncSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        Date expiryTime = sessionCredentialsHolder.getSessionCredentialsExpiration();
        if (expiryTime != null) {
            long timeRemaining = expiryTime.getTime() - System.currentTimeMillis();
            return timeRemaining < ASYNC_REFRESH_EXPIRATION_IN_MILLIS;
        }
        return false;
    }
}

