/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.auth;

import com.amazonaws.1.11.21.shade.annotation.SdkInternalApi;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.auth.AWSSessionCredentials;
import com.amazonaws.1.11.21.shade.auth.BasicSessionCredentials;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.Credentials;
import java.util.Date;

@ThreadSafe
@SdkInternalApi
final class SessionCredentialsHolder {
    private final AWSSessionCredentials sessionCredentials;
    private final Date sessionCredentialsExpiration;

    SessionCredentialsHolder(Credentials credentials) {
        this.sessionCredentials = new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
        this.sessionCredentialsExpiration = credentials.getExpiration();
    }

    public AWSSessionCredentials getSessionCredentials() {
        return this.sessionCredentials;
    }

    public Date getSessionCredentialsExpiration() {
        return this.sessionCredentialsExpiration;
    }
}

