/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.1.11.21.shade.auth;

import com.amazonaws.1.11.21.shade.ClientConfiguration;
import com.amazonaws.1.11.21.shade.annotation.ThreadSafe;
import com.amazonaws.1.11.21.shade.auth.AWSCredentials;
import com.amazonaws.1.11.21.shade.auth.AWSCredentialsProvider;
import com.amazonaws.1.11.21.shade.auth.AWSSessionCredentials;
import com.amazonaws.1.11.21.shade.auth.AWSSessionCredentialsProvider;
import com.amazonaws.1.11.21.shade.auth.RefreshableTask;
import com.amazonaws.1.11.21.shade.auth.SessionCredentialsHolder;
import com.amazonaws.1.11.21.shade.auth.ShouldDoAsyncSessionRefresh;
import com.amazonaws.1.11.21.shade.auth.ShouldDoBlockingSessionRefresh;
import com.amazonaws.1.11.21.shade.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.1.11.21.shade.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.1.11.21.shade.services.securitytoken.model.GetSessionTokenResult;
import java.util.concurrent.Callable;

@ThreadSafe
public class STSSessionCredentialsProvider
implements AWSSessionCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private final AWSSecurityTokenService securityTokenService;
    private final Callable<SessionCredentialsHolder> refreshCallable = new Callable<SessionCredentialsHolder>(){

        @Override
        public SessionCredentialsHolder call() throws Exception {
            return STSSessionCredentialsProvider.this.newSession();
        }
    };
    private volatile RefreshableTask<SessionCredentialsHolder> refreshableTask;

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials) {
        this(longLivedCredentials, new ClientConfiguration());
    }

    public STSSessionCredentialsProvider(AWSCredentials longLivedCredentials, ClientConfiguration clientConfiguration) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentials, clientConfiguration));
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentialsProvider));
    }

    public STSSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(new AWSSecurityTokenServiceClient(longLivedCredentialsProvider, clientConfiguration));
    }

    private RefreshableTask<SessionCredentialsHolder> createRefreshableTask() {
        return new RefreshableTask.Builder<SessionCredentialsHolder>().withRefreshCallable(this.refreshCallable).withBlockingRefreshPredicate(new ShouldDoBlockingSessionRefresh()).withAsyncRefreshPredicate(new ShouldDoAsyncSessionRefresh()).build();
    }

    public STSSessionCredentialsProvider(AWSSecurityTokenService sts) {
        this.securityTokenService = sts;
        this.refreshableTask = this.createRefreshableTask();
    }

    @Deprecated
    public synchronized void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.refreshableTask = this.createRefreshableTask();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        return this.refreshableTask.getValue().getSessionCredentials();
    }

    @Override
    public void refresh() {
        this.refreshableTask.forceGetValue();
    }

    private SessionCredentialsHolder newSession() {
        GetSessionTokenResult sessionTokenResult = this.securityTokenService.getSessionToken(new GetSessionTokenRequest().withDurationSeconds(3600));
        return new SessionCredentialsHolder(sessionTokenResult.getCredentials());
    }
}

