/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.transformers;

import com.rometools.rome.feed.WireFeed;
import com.rometools.rome.feed.rss.Content;
import com.rometools.rome.feed.rss.Description;
import com.rometools.rome.feed.rss.Guid;
import com.rometools.rome.feed.rss.Item;
import com.rometools.rome.feed.rss.Source;
import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.WireFeedParser;
import com.rometools.rome.io.impl.DateParser;
import com.rometools.rome.io.impl.RSS20Parser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class RssParser
extends RSS20Parser
implements WireFeedParser {
    private List<Namespace> namespaces;

    public String getType() {
        return "rss_2.0";
    }

    public boolean isMyType(Document document) {
        return true;
    }

    protected Namespace getRSSNamespace() {
        return Namespace.NO_NAMESPACE;
    }

    public Item parseItem(Element rssRoot, Element itemElement, Locale locale) {
        Item item = super.parseItem(rssRoot, itemElement, locale);
        this.parseTitle(item, itemElement);
        this.parseLink(item, itemElement);
        this.parseDescription(item, itemElement);
        this.parseAuthor(item, itemElement);
        this.parseComments(item, itemElement);
        this.parseSource(item, itemElement);
        this.parseGuid(item, itemElement);
        this.parsePubDate(item, itemElement, locale);
        this.parseExpirationDate(item, itemElement, locale);
        this.parseContent(item, itemElement);
        this.parseCategories(item, itemElement);
        return item;
    }

    private Element parseChildWithNamespaces(Element parentElement, String childName) {
        Element element = null;
        Iterator<Namespace> namespacesIterator = this.namespaces.iterator();
        while (namespacesIterator.hasNext() && element == null) {
            Namespace namespace = namespacesIterator.next();
            element = parentElement.getChild(childName, namespace);
        }
        return element;
    }

    private List<Element> parseChildrenWithNamespaces(Element parentElement, String childName) {
        List<Object> elements = new ArrayList<Element>();
        Iterator<Namespace> namespacesIterator = this.namespaces.iterator();
        while (namespacesIterator.hasNext() && elements.size() == 0) {
            Namespace namespace = namespacesIterator.next();
            elements = parentElement.getChildren(childName, namespace);
        }
        return elements;
    }

    public WireFeed parse(Document document, boolean validate, Locale locale) throws IllegalArgumentException, FeedException {
        Element rssRoot = document.getRootElement();
        this.namespaces = new ArrayList<Namespace>(rssRoot.getAdditionalNamespaces());
        this.namespaces.add(Namespace.NO_NAMESPACE);
        return this.parseChannel(rssRoot, locale);
    }

    private void parseTitle(Item item, Element itemElement) {
        Element title;
        if (item.getTitle() == null && (title = this.parseChildWithNamespaces(itemElement, "title")) != null) {
            item.setTitle(title.getText());
        }
    }

    private void parseLink(Item item, Element itemElement) {
        Element link;
        if (item.getLink() == null && (link = this.parseChildWithNamespaces(itemElement, "link")) != null) {
            item.setLink(link.getText());
            item.setUri(link.getText());
        }
    }

    private void parseDescription(Item item, Element itemElement) {
        Element description;
        if (item.getDescription() == null && (description = this.parseChildWithNamespaces(itemElement, "description")) != null) {
            Description descriptionBean = new Description();
            descriptionBean.setValue(description.getText());
            item.setDescription(descriptionBean);
            String type = description.getAttributeValue("type");
            if (type != null) {
                item.getDescription().setType(type);
            }
        }
    }

    private void parseAuthor(Item item, Element itemElement) {
        Element author;
        if (item.getAuthor() == null && (author = this.parseChildWithNamespaces(itemElement, "author")) != null) {
            item.setAuthor(author.getText());
        }
    }

    private void parseComments(Item item, Element itemElement) {
        Element comments;
        if (item.getComments() == null && (comments = this.parseChildWithNamespaces(itemElement, "comments")) != null) {
            item.setComments(comments.getText());
        }
    }

    private void parseSource(Item item, Element itemElement) {
        Element source;
        if (item.getSource() == null && (source = this.parseChildWithNamespaces(itemElement, "source")) != null) {
            Source sourceBean = new Source();
            sourceBean.setValue(source.getText());
            String url = source.getAttributeValue("url");
            sourceBean.setUrl(url);
            item.setSource(sourceBean);
        }
    }

    private void parseGuid(Item item, Element itemElement) {
        Element guid;
        if (item.getGuid() == null && (guid = this.parseChildWithNamespaces(itemElement, "guid")) != null) {
            Guid guidBean = new Guid();
            String isPermaLink = guid.getAttributeValue("isPermaLink");
            if (isPermaLink != null) {
                guidBean.setPermaLink(isPermaLink.equalsIgnoreCase("true"));
            }
            guidBean.setValue(guid.getText());
            item.setGuid(guidBean);
        }
    }

    private void parsePubDate(Item item, Element itemElement, Locale locale) {
        Element pubDate;
        if (item.getPubDate() == null && (pubDate = this.parseChildWithNamespaces(itemElement, "pubDate")) != null) {
            item.setPubDate(DateParser.parseDate((String)pubDate.getText(), (Locale)locale));
        }
    }

    private void parseExpirationDate(Item item, Element itemElement, Locale locale) {
        Element expirationDate;
        if (item.getExpirationDate() == null && (expirationDate = this.parseChildWithNamespaces(itemElement, "expirationDate")) != null) {
            item.setExpirationDate(DateParser.parseDate((String)expirationDate.getText(), (Locale)locale));
        }
    }

    private void parseContent(Item item, Element itemElement) {
        Element encoded;
        if (item.getContent() == null && (encoded = this.parseChildWithNamespaces(itemElement, "encoded")) != null) {
            Content content = new Content();
            content.setType("html");
            content.setValue(encoded.getText());
            item.setContent(content);
        }
    }

    private void parseCategories(Item item, Element itemElement) {
        if (item.getCategories() != null && item.getCategories().size() == 0) {
            List<Element> categories = this.parseChildrenWithNamespaces(itemElement, "category");
            item.setCategories(this.parseCategories(categories));
        }
    }
}

