/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.rss.endpoint;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.endpoint.AbstractMetaEndpointBuilder;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.endpoint.URIBuilder;
import org.mule.module.rss.endpoint.RssInboundEndpoint;
import org.mule.transport.http.HttpPollingConnector;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RssEndpointBuilder
extends AbstractMetaEndpointBuilder {
    public static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss";
    public static final String SHORT_DATE_FORMAT = "yyyy-MM-dd";
    private boolean splitFeed = true;
    private String lastUpdate = null;
    private List<String> acceptedMimeTypes;
    private long pollingFrequency = 1000L;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private final SimpleDateFormat shortDateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public RssEndpointBuilder() {
        this.init();
    }

    public RssEndpointBuilder(EndpointURIEndpointBuilder global) throws EndpointException {
        super(global);
        this.init();
    }

    public RssEndpointBuilder(URIBuilder URIBuilder2, MuleContext muleContext) {
        super(URIBuilder2);
        this.init();
    }

    public RssEndpointBuilder(String address, MuleContext muleContext) {
        super(address, muleContext);
        this.init();
    }

    protected RssEndpointBuilder(EndpointURI endpointURI, MuleContext muleContext) {
        super(endpointURI);
        this.init();
    }

    protected void init() {
        this.shortDateFormatter.setLenient(false);
        this.dateFormatter.setLenient(false);
        this.acceptedMimeTypes = new ArrayList<String>();
        this.acceptedMimeTypes.add("application/rss+xml");
        this.acceptedMimeTypes.add("application/rss");
        this.acceptedMimeTypes.add("text/xml");
    }

    public InboundEndpoint buildInboundEndpoint() throws EndpointException, InitialisationException {
        try {
            Date date = this.formatDate(this.getLastUpdate());
            RssInboundEndpoint in = new RssInboundEndpoint(this.isSplitFeed(), date, this.getAcceptedMimeTypes(), super.buildInboundEndpoint());
            in.registerSupportedProtocol("http");
            in.registerSupportedProtocol("https");
            in.registerSupportedProtocol("vm");
            if (in.getConnector() instanceof HttpPollingConnector) {
                ((HttpPollingConnector)in.getConnector()).setPollingFrequency(this.pollingFrequency);
            }
            return in;
        }
        catch (ParseException e) {
            throw new EndpointException((Throwable)e);
        }
    }

    public OutboundEndpoint buildOutboundEndpoint() throws EndpointException, InitialisationException {
        throw new UnsupportedOperationException("Outbound RSS endpoints not supported");
    }

    protected boolean isAlwaysCreateConnector() {
        return true;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public boolean isSplitFeed() {
        return this.splitFeed;
    }

    public void setSplitFeed(boolean splitFeed) {
        this.splitFeed = splitFeed;
    }

    public List<String> getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(List<String> acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public long getPollingFrequency() {
        return this.pollingFrequency;
    }

    public void setPollingFrequency(long pollingFrequency) {
        this.pollingFrequency = pollingFrequency;
    }

    protected Date formatDate(String date) throws ParseException {
        Date lastUpdateDate = null;
        if (StringUtils.isNotBlank((String)date)) {
            lastUpdateDate = this.lastUpdate.length() == 10 ? this.shortDateFormatter.parse(date) : this.dateFormatter.parse(date);
        }
        return lastUpdateDate;
    }
}

