/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.pgp;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.util.IOUtils;
import org.mule.runtime.core.util.SecurityUtils;
import org.mule.runtime.module.pgp.PGPKeyRing;
import org.mule.runtime.module.pgp.i18n.PGPMessages;
import org.mule.runtime.module.pgp.util.BouncyCastleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PGPKeyRingImpl
implements PGPKeyRing,
Initialisable {
    protected static final Logger logger = LoggerFactory.getLogger(PGPKeyRingImpl.class);
    private String publicKeyRingFileName;
    private HashMap<String, PGPPublicKey> principalsKeyBundleMap;
    private String secretKeyRingFileName;
    private String secretAliasId;
    private PGPSecretKey secretKey;
    private String secretPassphrase;

    public void initialise() throws InitialisationException {
        try {
            if (!SecurityUtils.isFipsSecurityModel()) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            this.principalsKeyBundleMap = new HashMap();
            this.readPublicKeyRing();
            this.readPrivateKeyBundle();
        }
        catch (Exception e) {
            logger.error("Error in initialise:" + e.getMessage(), (Throwable)e);
            throw new InitialisationException(CoreMessages.failedToCreate((String)"PGPKeyRingImpl"), (Throwable)e, (Initialisable)this);
        }
    }

    private void readPublicKeyRing() throws Exception {
        InputStream in = IOUtils.getResourceAsStream((String)this.getPublicKeyRingFileName(), this.getClass());
        PGPPublicKeyRingCollection collection = new PGPPublicKeyRingCollection(in, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
        in.close();
        Iterator iterator = collection.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing ring = (PGPPublicKeyRing)iterator.next();
            String userID = "";
            Iterator iterator2 = ring.getPublicKeys();
            while (iterator2.hasNext()) {
                PGPPublicKey publicKey = (PGPPublicKey)iterator2.next();
                Iterator userIDs = publicKey.getUserIDs();
                if (userIDs.hasNext()) {
                    userID = (String)userIDs.next();
                }
                this.principalsKeyBundleMap.put(userID, publicKey);
            }
        }
    }

    private void readPrivateKeyBundle() throws Exception {
        InputStream in = IOUtils.getResourceAsStream((String)this.getSecretKeyRingFileName(), this.getClass());
        PGPSecretKeyRingCollection collection = new PGPSecretKeyRingCollection(in, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
        in.close();
        this.secretKey = collection.getSecretKey(Long.valueOf(this.getSecretAliasId()).longValue());
        if (this.secretKey == null) {
            StringBuilder message = new StringBuilder();
            message.append('\n');
            Iterator iterator = collection.getKeyRings();
            while (iterator.hasNext()) {
                PGPSecretKeyRing ring = (PGPSecretKeyRing)iterator.next();
                Iterator secretKeysIterator = ring.getSecretKeys();
                while (secretKeysIterator.hasNext()) {
                    PGPSecretKey k = (PGPSecretKey)secretKeysIterator.next();
                    message.append("Key: ");
                    message.append(k.getKeyID());
                    message.append('\n');
                }
            }
            throw new InitialisationException(PGPMessages.noSecretKeyFoundButAvailable(message.toString()), (Initialisable)this);
        }
    }

    public String getSecretKeyRingFileName() {
        return this.secretKeyRingFileName;
    }

    public void setSecretKeyRingFileName(String value) {
        this.secretKeyRingFileName = value;
    }

    public String getSecretAliasId() {
        return this.secretAliasId;
    }

    public void setSecretAliasId(String value) {
        this.secretAliasId = value;
    }

    @Override
    public String getSecretPassphrase() {
        return this.secretPassphrase;
    }

    public void setSecretPassphrase(String value) {
        this.secretPassphrase = value;
    }

    @Override
    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKeyRingFileName() {
        return this.publicKeyRingFileName;
    }

    public void setPublicKeyRingFileName(String value) {
        this.publicKeyRingFileName = value;
    }

    @Override
    public PGPPublicKey getPublicKey(String principalId) {
        return this.principalsKeyBundleMap.get(principalId);
    }
}

