/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.pgp;

import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Calendar;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.EncryptionStrategy;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.security.CredentialsAccessor;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.security.AbstractNamedEncryptionStrategy;
import org.mule.runtime.core.util.SecurityUtils;
import org.mule.runtime.module.pgp.DecryptStreamTransformer;
import org.mule.runtime.module.pgp.EncryptStreamTransformer;
import org.mule.runtime.module.pgp.InvalidPublicKeyException;
import org.mule.runtime.module.pgp.LazyTransformedInputStream;
import org.mule.runtime.module.pgp.PGPCryptInfo;
import org.mule.runtime.module.pgp.PGPKeyRing;
import org.mule.runtime.module.pgp.TransformContinuouslyPolicy;
import org.mule.runtime.module.pgp.i18n.PGPMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyBasedEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected static final Logger logger = LoggerFactory.getLogger(KeyBasedEncryptionStrategy.class);
    private PGPKeyRing keyManager;
    private CredentialsAccessor credentialsAccessor;
    private boolean checkKeyExpirity = false;
    private Provider provider;

    public void initialise() throws InitialisationException {
        if (!SecurityUtils.isFipsSecurityModel()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.provider = SecurityUtils.getDefaultSecurityProvider();
    }

    public InputStream encrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = this.safeGetCryptInfo(cryptInfo);
            PGPPublicKey publicKey = pgpCryptInfo.getPublicKey();
            EncryptStreamTransformer transformer = new EncryptStreamTransformer(data, publicKey, this.provider);
            return new LazyTransformedInputStream(new TransformContinuouslyPolicy(), transformer);
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    public InputStream decrypt(InputStream data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = this.safeGetCryptInfo(cryptInfo);
            PGPPublicKey publicKey = pgpCryptInfo.getPublicKey();
            DecryptStreamTransformer transformer = new DecryptStreamTransformer(data, publicKey, this.keyManager.getSecretKey(), this.keyManager.getSecretPassphrase(), this.provider);
            return new LazyTransformedInputStream(new TransformContinuouslyPolicy(), transformer);
        }
        catch (Exception e) {
            throw new CryptoFailureException((EncryptionStrategy)this, (Throwable)e);
        }
    }

    private PGPCryptInfo safeGetCryptInfo(Object cryptInfo) {
        if (cryptInfo == null) {
            Event event = Event.getCurrentEvent();
            PGPPublicKey publicKey = this.keyManager.getPublicKey((String)((Object)this.getCredentialsAccessor().getCredentials(event)));
            this.checkKeyExpirity(publicKey);
            return new PGPCryptInfo(publicKey, false);
        }
        PGPCryptInfo info = (PGPCryptInfo)cryptInfo;
        this.checkKeyExpirity(info.getPublicKey());
        return info;
    }

    private void checkKeyExpirity(PGPPublicKey publicKey) {
        if (this.isCheckKeyExpirity() && publicKey.getValidDays() != 0) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(publicKey.getCreationTime());
            calendar.add(5, publicKey.getValidDays());
            if (!calendar.getTime().after(Calendar.getInstance().getTime())) {
                throw new InvalidPublicKeyException(PGPMessages.pgpPublicKeyExpired());
            }
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }

    public CredentialsAccessor getCredentialsAccessor() {
        return this.credentialsAccessor;
    }

    public void setCredentialsAccessor(CredentialsAccessor credentialsAccessor) {
        this.credentialsAccessor = credentialsAccessor;
    }

    public boolean isCheckKeyExpirity() {
        return this.checkKeyExpirity;
    }

    public void setCheckKeyExpirity(boolean checkKeyExpirity) {
        this.checkKeyExpirity = checkKeyExpirity;
    }
}

