/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.pgp;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.pgp.PGPKeyRing;
import org.mule.module.pgp.exception.MissingPGPKeyException;
import org.mule.module.pgp.i18n.PGPMessages;
import org.mule.module.pgp.util.BouncyCastleUtil;
import org.mule.module.pgp.util.ValidatorUtil;
import org.mule.util.IOUtils;
import org.mule.util.SecurityUtils;

public class PGPKeyRingImpl
implements PGPKeyRing,
Initialisable {
    protected static final Log logger = LogFactory.getLog(PGPKeyRingImpl.class);
    private String publicKeyRingFileName;
    private HashMap<String, PGPPublicKey> principalsKeyBundleMap;
    private String secretKeyRingFileName;
    private String secretAliasId;
    private PGPSecretKey secretKey;
    private String secretPassPhrase;
    private PGPSecretKeyRingCollection secretKeys;
    private PGPPublicKeyRingCollection publicKeys;
    private boolean readSecretKey;

    public void initialise() throws InitialisationException {
        try {
            if (!SecurityUtils.isFipsSecurityModel()) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error in Initialisation: " + e.getMessage()), (Throwable)e);
            throw new InitialisationException(CoreMessages.failedToCreate((String)"PGPKeyRingImpl"), (Throwable)e, (Initialisable)this);
        }
    }

    private void readPublicKeyRing() {
        try {
            ValidatorUtil.validateNotNull(this.getPublicKeyRingFileName(), PGPMessages.noPublicKeyDefined());
            InputStream inputStream = IOUtils.getResourceAsStream((String)this.getPublicKeyRingFileName(), this.getClass());
            ValidatorUtil.validateNotNull(inputStream, PGPMessages.noFileKeyFound(this.getPublicKeyRingFileName()));
            this.publicKeys = new PGPPublicKeyRingCollection(inputStream, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
            inputStream.close();
            this.principalsKeyBundleMap = new HashMap();
            Iterator keyRingsIterator = this.publicKeys.getKeyRings();
            while (keyRingsIterator.hasNext()) {
                PGPPublicKeyRing ring = (PGPPublicKeyRing)keyRingsIterator.next();
                String userID = "";
                Iterator publicKeysIterator = ring.getPublicKeys();
                while (publicKeysIterator.hasNext()) {
                    PGPPublicKey publicKey = (PGPPublicKey)publicKeysIterator.next();
                    Iterator userIDs = publicKey.getUserIDs();
                    if (userIDs.hasNext()) {
                        userID = (String)userIDs.next();
                    }
                    this.principalsKeyBundleMap.put(userID, publicKey);
                }
            }
        }
        catch (IOException | PGPException e) {
            throw new MissingPGPKeyException(e);
        }
    }

    private void readPrivateKeyBundle() {
        try {
            ValidatorUtil.validateNotNull(this.getSecretKeyRingFileName(), PGPMessages.noSecretKeyDefined());
            InputStream secretKeyInputStream = IOUtils.getResourceAsStream((String)this.getSecretKeyRingFileName(), this.getClass());
            ValidatorUtil.validateNotNull(secretKeyInputStream, PGPMessages.noFileKeyFound(this.getSecretKeyRingFileName()));
            this.secretKeys = new PGPSecretKeyRingCollection(secretKeyInputStream, (KeyFingerPrintCalculator)BouncyCastleUtil.KEY_FINGERPRINT_CALCULATOR);
            secretKeyInputStream.close();
            String secretAliasId = this.getSecretAliasId();
            if (secretAliasId != null) {
                this.secretKey = this.secretKeys.getSecretKey(this.parseSecretAliasId(secretAliasId).longValue());
                ValidatorUtil.validateNotNull(this.secretKey, PGPMessages.noKeyIdFound(this.getSecretAliasId()));
            }
            this.readSecretKey = true;
        }
        catch (IOException | PGPException e) {
            throw new MissingPGPKeyException(e);
        }
    }

    public String getSecretKeyRingFileName() {
        return this.secretKeyRingFileName;
    }

    public void setSecretKeyRingFileName(String value) {
        this.secretKeyRingFileName = value;
    }

    public String getSecretAliasId() {
        return this.secretAliasId;
    }

    public void setSecretAliasId(String value) {
        this.secretAliasId = value;
    }

    @Override
    public String getSecretPassphrase() {
        ValidatorUtil.validateNotNull(this.secretPassPhrase, PGPMessages.noSecretPassPhrase());
        return this.secretPassPhrase;
    }

    public void setSecretPassphrase(String value) {
        this.secretPassPhrase = value;
    }

    @Override
    public PGPSecretKey getConfiguredSecretKey() {
        if (!this.readSecretKey) {
            this.readPrivateKeyBundle();
        }
        return this.secretKey;
    }

    private Long parseSecretAliasId(String secretAliasId) {
        return new BigInteger(secretAliasId, 16).longValue();
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeys() {
        return this.secretKeys;
    }

    public String getPublicKeyRingFileName() {
        return this.publicKeyRingFileName;
    }

    public void setPublicKeyRingFileName(String value) {
        this.publicKeyRingFileName = value;
    }

    @Override
    public PGPPublicKey getPublicKey(String principalId) {
        if (this.principalsKeyBundleMap == null) {
            this.readPublicKeyRing();
        }
        return this.principalsKeyBundleMap.get(principalId);
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeys() {
        if (this.principalsKeyBundleMap == null) {
            this.readPublicKeyRing();
        }
        return this.publicKeys;
    }
}

