/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.pgp;

import cryptix.jce.provider.CryptixCrypto;
import cryptix.message.EncryptedMessage;
import cryptix.message.EncryptedMessageBuilder;
import cryptix.message.LiteralMessageBuilder;
import cryptix.message.Message;
import cryptix.message.MessageFactory;
import cryptix.message.SignedMessageBuilder;
import cryptix.openpgp.PGPArmouredMessage;
import cryptix.openpgp.provider.CryptixOpenPGP;
import cryptix.pki.KeyBundle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.pgp.PGPCryptInfo;
import org.mule.extras.pgp.PGPKeyRing;
import org.mule.impl.security.AbstractNamedEncryptionStrategy;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.security.CryptoFailureException;

public class KeyBasedEncryptionStrategy
extends AbstractNamedEncryptionStrategy {
    protected static final Log logger = LogFactory.getLog((Class)KeyBasedEncryptionStrategy.class);
    private PGPKeyRing keyManager;

    public byte[] encrypt(byte[] data, Object cryptInfo) throws CryptoFailureException {
        try {
            PGPCryptInfo pgpCryptInfo = (PGPCryptInfo)cryptInfo;
            KeyBundle publicKey = pgpCryptInfo.getKeyBundle();
            LiteralMessageBuilder lmb = LiteralMessageBuilder.getInstance((String)"OpenPGP");
            lmb.init(data);
            Message msg = lmb.build();
            if (pgpCryptInfo.isSignRequested()) {
                SignedMessageBuilder smb = SignedMessageBuilder.getInstance((String)"OpenPGP");
                smb.init(msg);
                smb.addSigner(this.keyManager.getSecretKeyBundle(), this.keyManager.getSecretPassphrase().toCharArray());
                msg = smb.build();
            }
            EncryptedMessageBuilder emb = EncryptedMessageBuilder.getInstance((String)"OpenPGP");
            emb.init(msg);
            emb.addRecipient(publicKey);
            msg = emb.build();
            return new PGPArmouredMessage(msg).getEncoded();
        }
        catch (Exception e) {
            throw new CryptoFailureException((UMOEncryptionStrategy)this, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] data, Object cryptInfo) throws CryptoFailureException {
        try {
            MessageFactory mf = MessageFactory.getInstance((String)"OpenPGP");
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Collection msgs = mf.generateMessages((InputStream)in);
            Message msg = (Message)msgs.iterator().next();
            if (msg instanceof EncryptedMessage) {
                msg = ((EncryptedMessage)msg).decrypt(this.keyManager.getSecretKeyBundle(), this.keyManager.getSecretPassphrase().toCharArray());
                return new PGPArmouredMessage(msg).getEncoded();
            }
        }
        catch (Exception e) {
            throw new CryptoFailureException((UMOEncryptionStrategy)this, (Throwable)e);
        }
        return data;
    }

    public void initialise() throws InitialisationException {
        try {
            Security.addProvider((Provider)new CryptixCrypto());
            Security.addProvider((Provider)new CryptixOpenPGP());
        }
        catch (Exception e) {
            throw new InitialisationException(CoreMessages.failedToCreate((String)"KeyBasedEncryptionStrategy"), (Throwable)e, (Initialisable)this);
        }
    }

    public PGPKeyRing getKeyManager() {
        return this.keyManager;
    }

    public void setKeyManager(PGPKeyRing keyManager) {
        this.keyManager = keyManager;
    }
}

