/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.objectstore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.registry.Registry;
import org.mule.api.store.ListableObjectStore;
import org.mule.api.store.ObjectAlreadyExistsException;
import org.mule.api.store.ObjectDoesNotExistException;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.api.store.ObjectStoreManager;
import org.mule.api.transport.PropertyScope;
import org.mule.modules.objectstore.Config;
import org.mule.modules.objectstore.MulePropertyScope;
import org.mule.util.StringUtils;

public class ObjectStoreConnector {
    private Config config;
    @Inject
    private Registry registry;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private MuleContext muleContext = null;
    private String sharedObjectStoreLockId = null;
    private ObjectStore<Serializable> objectStore;
    private static String INVALID_PARAMETERS_ERROR = "You must either provide all Entry TTL, Max Entries and Expiration Interval, or none of them";
    private static String PARTITION_REQUIRED_ERROR = "For Object Stores that expire entries, you must provide a partition name. Any name will do as long as it's unique.";

    @PostConstruct
    public void init() {
        if (this.config.getObjectStore() == null) {
            if (this.config.getEntryTtl() != null || this.config.getMaxEntries() != null || this.config.getExpirationInterval() != null) {
                if (this.config.getEntryTtl() == null || this.config.getMaxEntries() == null || this.config.getExpirationInterval() == null) {
                    throw new IllegalArgumentException(INVALID_PARAMETERS_ERROR);
                }
                if (StringUtils.isEmpty((String)this.config.getPartition())) {
                    throw new IllegalArgumentException(PARTITION_REQUIRED_ERROR);
                }
            }
            ObjectStore objectStore = this.config.getEntryTtl() != null && this.config.getMaxEntries() != null && this.config.getExpirationInterval() != null ? this.objectStoreManager.getObjectStore(this.config.getPartition(), this.config.getPersistent(), this.config.getMaxEntries().intValue(), this.config.getEntryTtl().intValue(), this.config.getExpirationInterval().intValue()) : (StringUtils.isNotEmpty((String)this.config.getPartition()) ? this.objectStoreManager.getObjectStore(this.config.getPartition(), this.config.getPersistent()) : (ObjectStore)this.registry.lookupObject("_defaultUserObjectStore"));
            this.config.setObjectStore((ObjectStore<Serializable>)objectStore);
            if (this.config.getObjectStore() == null) {
                throw new IllegalArgumentException("Unable to acquire an object store.");
            }
        }
        if (this.sharedObjectStoreLockId == null) {
            this.sharedObjectStoreLockId = new Random().nextInt(1000) + "-" + System.currentTimeMillis() + "-lock";
        }
        this.objectStore = this.config.getObjectStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String key, Serializable value, boolean overwrite) throws ObjectStoreException {
        block6: {
            Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId);
            lock.lock();
            try {
                this.objectStore.store((Serializable)((Object)key), value);
            }
            catch (ObjectAlreadyExistsException e) {
                if (overwrite) {
                    this.objectStore.remove((Serializable)((Object)key));
                    this.objectStore.store((Serializable)((Object)key), value);
                    break block6;
                }
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dualStore(String key, Serializable value, boolean overwrite) throws ObjectStoreException {
        block10: {
            Serializable previousValue = null;
            Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId);
            lock.lock();
            try {
                try {
                    this.objectStore.store((Serializable)((Object)key), value);
                }
                catch (ObjectAlreadyExistsException e) {
                    if (overwrite) {
                        previousValue = this.objectStore.retrieve((Serializable)((Object)key));
                        this.objectStore.remove((Serializable)((Object)key));
                        this.objectStore.store((Serializable)((Object)key), value);
                    }
                    throw e;
                }
                try {
                    this.objectStore.store(value, (Serializable)((Object)key));
                }
                catch (ObjectAlreadyExistsException e) {
                    if (overwrite) {
                        this.config.getObjectStore().remove(value);
                        this.config.getObjectStore().store(value, (Serializable)((Object)key));
                        break block10;
                    }
                    this.rollbackDualStore(key, previousValue);
                    throw e;
                }
                catch (Exception e) {
                    this.rollbackDualStore(key, previousValue);
                    throw new ObjectStoreException((Throwable)e);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    public Object retrieve(String key, Object defaultValue, String targetProperty, MulePropertyScope targetScope, MuleMessage muleMessage) throws ObjectStoreException {
        Object ret;
        try {
            ret = this.objectStore.retrieve((Serializable)((Object)key));
        }
        catch (ObjectDoesNotExistException ose) {
            if (defaultValue != null) {
                ret = defaultValue;
            }
            throw ose;
        }
        if (targetProperty != null) {
            muleMessage.setProperty(targetProperty, ret, PropertyScope.get((String)targetScope.value()));
            ret = muleMessage.getPayload();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object retrieveWithLock(String key, Object defaultValue, String targetProperty, MulePropertyScope targetScope, MuleMessage muleMessage) throws ObjectStoreException {
        Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId);
        lock.lock();
        try {
            Object object = this.retrieve(key, defaultValue, targetProperty, targetScope, muleMessage);
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    public Object retrieveStore(String key, Object defaultValue, Serializable storeValue, String targetProperty, MulePropertyScope targetScope, MuleMessage muleMessage) throws ObjectStoreException {
        Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId);
        lock.lock();
        Object ret = this.retrieve(key, defaultValue, targetProperty, targetScope, muleMessage);
        try {
            if (this.objectStore.contains((Serializable)((Object)key))) {
                this.objectStore.remove((Serializable)((Object)key));
            }
            this.objectStore.store((Serializable)((Object)key), storeValue);
            this.store(key, storeValue, true);
        }
        catch (ObjectStoreException ose) {
            throw ose;
        }
        finally {
            lock.unlock();
        }
        return ret;
    }

    public Object remove(String key, boolean ignoreNotExists) throws ObjectStoreException {
        Lock lock = this.muleContext.getLockFactory().createLock(this.sharedObjectStoreLockId);
        lock.lock();
        try {
            Serializable serializable = this.objectStore.remove((Serializable)((Object)key));
            return serializable;
        }
        catch (ObjectDoesNotExistException e) {
            if (ignoreNotExists) {
                Object var5_6 = null;
                return var5_6;
            }
            throw e;
        }
        finally {
            lock.unlock();
        }
    }

    public List<String> allKeys() throws ObjectStoreException {
        if (this.objectStore instanceof ListableObjectStore) {
            List allkeys = ((ListableObjectStore)this.objectStore).allKeys();
            ArrayList<String> list = new ArrayList<String>();
            for (Serializable key : allkeys) {
                if (key instanceof String) {
                    list.add((String)((Object)key));
                    continue;
                }
                throw new UnsupportedOperationException("The objectStore [" + this.objectStore.getClass().getName() + "] supports only keys of type: " + String.class.getName());
            }
            return list;
        }
        throw new UnsupportedOperationException("The objectStore [" + this.objectStore.getClass().getName() + "] does not support the operation allKeys");
    }

    public boolean contains(String key) throws ObjectStoreException {
        return this.objectStore.contains((Serializable)((Object)key));
    }

    private void rollbackDualStore(@NotNull String key, Serializable previousValue) throws ObjectStoreException {
        this.silentlyDelete(key);
        if (previousValue != null) {
            this.objectStore.store((Serializable)((Object)key), previousValue);
        }
    }

    private void silentlyDelete(@NotNull String key) throws ObjectStoreException {
        this.objectStore.remove((Serializable)((Object)key));
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(@NotNull Config config) {
        this.config = config;
    }

    public ObjectStoreManager getObjectStoreManager() {
        return this.objectStoreManager;
    }

    public void setObjectStoreManager(@NotNull ObjectStoreManager objectStoreManager) {
        this.objectStoreManager = objectStoreManager;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(@NotNull Registry registry) {
        this.registry = registry;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

