
package org.mule.modules.objectstore.config;

import javax.annotation.Generated;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;


/**
 * Registers bean definitions parsers for handling elements in <code>http://www.mulesoft.org/schema/mule/objectstore</code>.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.7.0", date = "2015-07-31T05:23:03-03:00", comments = "Build mule-devkit-3.7.0.2589.361fd9f")
public class ObjectstoreNamespaceHandler
    extends NamespaceHandlerSupport
{

    private static Logger logger = LoggerFactory.getLogger(ObjectstoreNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        } catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [objectstore] is not supported in mule ")+ muleVersion));
        throw new FatalBeanException(((((("Cannot launch the mule app, the  "+ beanScope)+" [")+ beanName)+"] within the connector [objectstore] is not supported in mule ")+ muleVersion), noClassDefFoundError);
    }

    /**
     * Invoked by the {@link DefaultBeanDefinitionDocumentReader} after construction but before any custom elements are parsed. 
     * @see NamespaceHandlerSupport#registerBeanDefinitionParser(String, BeanDefinitionParser)
     * 
     */
    public void init() {
        try {
            this.registerBeanDefinitionParser("config", new ObjectStoreConnectorConfigConfigDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("store", new StoreDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("dual-store", new DualStoreDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("dual-store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve", new RetrieveDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("retrieve", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve-with-lock", new RetrieveWithLockDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("retrieve-with-lock", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("retrieve-store", new RetrieveStoreDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("retrieve-store", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("remove", new RemoveDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("remove", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("all-keys", new AllKeysDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("all-keys", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("contains", new ContainsDefinitionParser());
        } catch (NoClassDefFoundError ex) {
            handleException("contains", "@Processor", ex);
        }
    }

}
