/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.tokenmanager;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.config.i18n.CoreMessages;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.module.oauth2.internal.tokenmanager.TokenManagerConfig;

public class InvalidateOauthContextMessageProcessor
implements Processor,
Initialisable,
MuleContextAware {
    private TokenManagerConfig config;
    private AttributeEvaluator resourceOwnerIdEvaluator;
    private MuleContext muleContext;

    public Event process(Event event) throws MuleException {
        String resourceOwnerId = this.resourceOwnerIdEvaluator.resolveStringValue(event);
        if (resourceOwnerId == null) {
            throw new MessagingException(CoreMessages.createStaticMessage((String)"Resource owner id cannot be null"), event, (Processor)this);
        }
        this.config.getConfigOAuthContext().clearContextForResourceOwner(resourceOwnerId);
        return event;
    }

    public void setConfig(TokenManagerConfig config) {
        this.config = config;
    }

    public void setResourceOwnerId(String resourceOwnerId) {
        this.resourceOwnerIdEvaluator = new AttributeEvaluator(resourceOwnerId);
    }

    public void initialise() throws InitialisationException {
        if (this.resourceOwnerIdEvaluator == null) {
            this.resourceOwnerIdEvaluator = new AttributeEvaluator("default");
        }
        this.resourceOwnerIdEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

