/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.oauth2.internal.clientcredentials;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.MessageExchangePattern;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.EventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.message.InternalMessage;
import org.mule.runtime.core.construct.Flow;
import org.mule.runtime.module.oauth2.internal.AbstractTokenRequestHandler;
import org.mule.runtime.module.oauth2.internal.ApplicationCredentials;
import org.mule.runtime.module.oauth2.internal.MuleEventLogger;
import org.mule.runtime.module.oauth2.internal.TokenNotFoundException;
import org.mule.runtime.module.oauth2.internal.TokenResponseProcessor;
import org.mule.runtime.module.oauth2.internal.authorizationcode.TokenResponseConfiguration;
import org.mule.runtime.module.oauth2.internal.authorizationcode.state.ResourceOwnerOAuthContext;
import org.mule.runtime.module.oauth2.internal.tokenmanager.TokenManagerConfig;

public class ClientCredentialsTokenRequestHandler
extends AbstractTokenRequestHandler {
    private String scopes;
    private ApplicationCredentials applicationCredentials;
    private TokenResponseConfiguration tokenResponseConfiguration = new TokenResponseConfiguration();
    private TokenManagerConfig tokenManager;
    private boolean encodeClientCredentialsInBody = false;
    private MuleEventLogger muleEventLogger;

    public void setApplicationCredentials(ApplicationCredentials applicationCredentials) {
        this.applicationCredentials = applicationCredentials;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public void setTokenResponseConfiguration(TokenResponseConfiguration tokenResponseConfiguration) {
        this.tokenResponseConfiguration = tokenResponseConfiguration;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        this.muleEventLogger = new MuleEventLogger(this.logger, muleContext);
    }

    private Event setMapPayloadWithTokenRequestParameters(Event event) throws MuleException {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        String clientId = this.applicationCredentials.getClientId();
        String clientSecret = this.applicationCredentials.getClientSecret();
        InternalMessage.Builder builder = InternalMessage.builder((InternalMessage)event.getMessage());
        if (this.encodeClientCredentialsInBody) {
            formData.put("client_id", clientId);
            formData.put("client_secret", clientSecret);
        } else {
            String encodedCredentials = Base64.encodeBase64String((byte[])String.format("%s:%s", clientId, clientSecret).getBytes());
            builder.addOutboundProperty("Authorization", (Serializable)((Object)("Basic " + encodedCredentials)));
        }
        if (this.scopes != null) {
            formData.put("scope", this.scopes);
        }
        return Event.builder((Event)event).message(builder.payload(formData).build()).build();
    }

    public void refreshAccessToken() throws MuleException {
        try {
            Flow flow = new Flow("test", this.getMuleContext());
            Event accessTokenEvent = Event.builder((EventContext)DefaultEventContext.create((FlowConstruct)flow, (String)"ClientCredentialsTokenRequestHandler")).message(InternalMessage.builder().nullPayload().build()).exchangePattern(MessageExchangePattern.REQUEST_RESPONSE).flow((FlowConstruct)flow).build();
            accessTokenEvent = this.setMapPayloadWithTokenRequestParameters(accessTokenEvent);
            Event response = this.invokeTokenUrl(accessTokenEvent);
            TokenResponseProcessor tokenResponseProcessor = TokenResponseProcessor.createClientCredentialsProcessor(this.tokenResponseConfiguration, this.getMuleContext().getExpressionManager());
            tokenResponseProcessor.process(response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponseProcessor.getAccessToken(), tokenResponseProcessor.getRefreshToken(), tokenResponseProcessor.getExpiresIn()});
            }
            if (!this.tokenResponseContentIsValid(tokenResponseProcessor)) {
                throw new TokenNotFoundException(response, tokenResponseProcessor);
            }
            ResourceOwnerOAuthContext defaultUserState = this.tokenManager.getConfigOAuthContext().getContextForResourceOwner("default");
            defaultUserState.setAccessToken(tokenResponseProcessor.getAccessToken());
            defaultUserState.setExpiresIn(tokenResponseProcessor.getExpiresIn());
            Map<String, Object> customResponseParameters = tokenResponseProcessor.getCustomResponseParameters();
            for (String paramName : customResponseParameters.keySet()) {
                defaultUserState.getTokenResponseParameters().put(paramName, customResponseParameters.get(paramName));
            }
            this.tokenManager.getConfigOAuthContext().updateResourceOwnerOAuthContext(defaultUserState);
        }
        catch (TokenNotFoundException e) {
            this.logger.error(String.format("Could not extract access token or refresh token from token URL. Access token is %s, Refresh token is %s", e.getTokenResponseProcessor().getAccessToken(), e.getTokenResponseProcessor().getRefreshToken()));
            this.muleEventLogger.logContent(e.getTokenUrlResponse());
            throw new DefaultMuleException((Throwable)e);
        }
        catch (AbstractTokenRequestHandler.TokenUrlResponseException e) {
            this.logger.error(String.format("HTTP response from token URL %s returned a failure status code", this.getTokenUrl()));
            this.muleEventLogger.logContent(e.getTokenUrlResponse());
            throw new DefaultMuleException((Throwable)e);
        }
    }

    private boolean tokenResponseContentIsValid(TokenResponseProcessor tokenResponseProcessor) {
        return tokenResponseProcessor.getAccessToken() != null;
    }

    public void setTokenManager(TokenManagerConfig tokenManager) {
        this.tokenManager = tokenManager;
    }

    public void setEncodeClientCredentialsInBody(boolean encodeClientCredentialsInBody) {
        this.encodeClientCredentialsInBody = encodeClientCredentialsInBody;
    }
}

